/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.cache.properties;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.impl.cache.Cache;
import com.atlassian.user.impl.cache.CacheManager;
import com.atlassian.user.impl.cache.properties.CachedPropertySet;
import com.atlassian.user.properties.PropertySetFactory;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.HashMap;

public class CachingPropertySetFactory
implements PropertySetFactory {
    private final PropertySetFactory underlyingPropertySetFactory;
    private final CacheManager cacheManager;

    public CachingPropertySetFactory(PropertySetFactory underlyingPropertySetFactory, CacheManager cacheManager) {
        this.underlyingPropertySetFactory = underlyingPropertySetFactory;
        this.cacheManager = cacheManager;
    }

    public PropertySet getPropertySet(Entity entity) throws EntityException {
        PropertySet propertySet = (PropertySet)this.getCache().get(entity.getName());
        if (propertySet == null) {
            propertySet = this.underlyingPropertySetFactory.getPropertySet(entity);
            HashMap<String, PropertySet> args = new HashMap<String, PropertySet>();
            args.put("PropertySet", propertySet);
            CachedPropertySet cachedPropertySet = new CachedPropertySet();
            cachedPropertySet.init(args, args);
            this.getCache().put(entity.getName(), cachedPropertySet);
        }
        return propertySet;
    }

    private Cache getCache() {
        String cacheName = this.underlyingPropertySetFactory.getClass().getName() + ".propertysets";
        return this.cacheManager.getCache(cacheName);
    }
}

