/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.cache;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.impl.cache.CacheManager;
import com.atlassian.user.impl.cache.EntityRepositoryCache;
import com.atlassian.user.impl.cache.GroupCache;
import com.atlassian.user.impl.cache.GroupsForUserCache;
import com.atlassian.user.impl.cache.MembershipCache;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.PagerUtils;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Category;

public class CachingGroupManager
implements GroupManager {
    private static final Category log = Category.getInstance((Class)CachingGroupManager.class);
    protected final GroupManager underlyingGroupManager;
    protected final CacheManager cacheManager;
    protected GroupCache groupCache = null;
    protected MembershipCache membershipCache = null;
    protected GroupsForUserCache groupsForUserCache = null;
    protected EntityRepositoryCache entityRepositoryCache = null;

    public CachingGroupManager(GroupManager underlyingGroupManager, CacheManager cacheManager) {
        this.underlyingGroupManager = underlyingGroupManager;
        this.cacheManager = cacheManager;
        this.initialiseCaches();
    }

    public Pager getGroups(User user) throws EntityException {
        LinkedList<String> groupNames;
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null.");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Retrieving groups for user [" + user.getName() + "]"));
        }
        if ((groupNames = this.groupsForUserCache.get(user)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cache hit. Returning pager with " + groupNames.size() + " items."));
            }
            LinkedList<Group> groups = new LinkedList<Group>();
            Iterator iter = groupNames.iterator();
            while (iter.hasNext()) {
                String groupName = (String)iter.next();
                groups.add(this.getGroup(groupName));
            }
            return new DefaultPager(groups);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Cache miss. Retrieving groups from underlying group manager.");
        }
        LinkedList<Group> groups = new LinkedList<Group>();
        groupNames = new LinkedList<String>();
        Iterator groupsIterator = this.underlyingGroupManager.getGroups(user).iterator();
        while (groupsIterator.hasNext()) {
            Group e = (Group)groupsIterator.next();
            groups.add(e);
            groupNames.add(e.getName());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieved " + groupNames.size() + " groups for user [" + user + "], putting in cache."));
        }
        this.groupsForUserCache.put(user, groupNames);
        return new DefaultPager(groups);
    }

    public Group getGroup(String groupName) throws EntityException {
        Group cachedGroup = this.groupCache.get(groupName);
        if (cachedGroup != null) {
            return GroupCache.NULL_GROUP.equals(cachedGroup) ? null : cachedGroup;
        }
        Group group = this.underlyingGroupManager.getGroup(groupName);
        this.groupCache.put(groupName, group);
        return group;
    }

    public Group createGroup(String groupName) throws EntityException {
        Group createdGroup = this.underlyingGroupManager.createGroup(groupName);
        if (createdGroup != null) {
            this.groupCache.put(createdGroup.getName(), createdGroup);
        }
        return createdGroup;
    }

    public void removeGroup(Group group) throws EntityException {
        List memberNames = PagerUtils.toList(this.getMemberNames(group));
        this.underlyingGroupManager.removeGroup(group);
        this.groupCache.remove(group.getName());
        this.groupsForUserCache.remove(memberNames);
        this.membershipCache.remove(memberNames, group);
        this.entityRepositoryCache.remove(group);
    }

    public void addMembership(Group group, User user) throws EntityException {
        this.underlyingGroupManager.addMembership(group, user);
        this.membershipCache.put(user, group, true);
        this.groupsForUserCache.remove(user);
    }

    public boolean hasMembership(Group group, User user) throws EntityException {
        if (group == null) {
            return false;
        }
        Boolean membershipCheckElement = this.membershipCache.get(user, group);
        if (membershipCheckElement != null) {
            return membershipCheckElement;
        }
        boolean isMember = this.underlyingGroupManager.hasMembership(group, user);
        this.membershipCache.put(user, group, isMember);
        return isMember;
    }

    public void removeMembership(Group group, User user) throws EntityException {
        this.underlyingGroupManager.removeMembership(group, user);
        this.membershipCache.remove(user, group);
        this.groupsForUserCache.remove(user);
    }

    public RepositoryIdentifier getRepository(Entity entity) throws EntityException {
        RepositoryIdentifier cachedRepository = this.entityRepositoryCache.get(entity);
        if (cachedRepository != null) {
            return cachedRepository;
        }
        RepositoryIdentifier repository = this.underlyingGroupManager.getRepository(entity);
        this.entityRepositoryCache.put(entity, repository);
        return repository;
    }

    public Pager getGroups() throws EntityException {
        return this.underlyingGroupManager.getGroups();
    }

    public Pager getMemberNames(Group group) throws EntityException {
        return this.underlyingGroupManager.getMemberNames(group);
    }

    public Pager getLocalMemberNames(Group group) throws EntityException {
        return this.underlyingGroupManager.getLocalMemberNames(group);
    }

    public Pager getExternalMemberNames(Group group) throws EntityException {
        return this.underlyingGroupManager.getExternalMemberNames(group);
    }

    public boolean supportsExternalMembership() throws EntityException {
        return this.underlyingGroupManager.supportsExternalMembership();
    }

    public boolean isReadOnly(Group group) throws EntityException {
        return this.underlyingGroupManager.isReadOnly(group);
    }

    public RepositoryIdentifier getIdentifier() {
        return this.underlyingGroupManager.getIdentifier();
    }

    public boolean isCreative() {
        return this.underlyingGroupManager.isCreative();
    }

    private void initialiseCaches() {
        this.entityRepositoryCache = new EntityRepositoryCache(this.cacheManager, this.getCacheKey("repositories"));
        this.groupCache = new GroupCache(this.cacheManager, this.getCacheKey("groups"));
        this.membershipCache = new MembershipCache(this.cacheManager, this.getCacheKey("groups_hasMembership"));
        this.groupsForUserCache = new GroupsForUserCache(this.cacheManager, this.getCacheKey("groups_getGroupsForUser"));
    }

    private String getCacheKey(String cacheName) {
        String className = this.underlyingGroupManager.getClass().getName();
        String repositoryKey = this.underlyingGroupManager.getIdentifier().getKey();
        return className + "." + repositoryKey + "." + cacheName;
    }
}

