/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.configuration.xml;

import com.atlassian.user.configuration.CacheConfiguration;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.DefaultCacheConfiguration;
import com.atlassian.user.configuration.DefaultRepositoryConfiguration;
import com.atlassian.user.configuration.RepositoryProcessor;
import com.atlassian.user.configuration.xml.XMLConfigUtil;
import com.atlassian.user.configuration.xml.XMLDefaultsParser;
import com.atlassian.user.repository.DefaultRepositoryIdentifier;
import com.atlassian.user.repository.RepositoryIdentifier;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class XMLConfigurationParser {
    private static final Logger log = Logger.getLogger((Class)XMLConfigurationParser.class);
    private final XMLDefaultsParser defaultsParser;
    private List repositoryIdentifiers = new ArrayList();
    private Map repositoryConfigurations = new HashMap();

    public XMLConfigurationParser() throws ConfigurationException {
        this("atlassian-user-defaults.xml");
    }

    public XMLConfigurationParser(String defaultsFileName) throws ConfigurationException {
        try {
            this.defaultsParser = new XMLDefaultsParser(defaultsFileName);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to load atlassian-user configuraiton parser: " + e.getMessage(), e);
        }
    }

    public void parse(InputStream docIS) throws ConfigurationException {
        try {
            Document doc;
            if (docIS == null) {
                throw new ConfigurationException("Null inputstream: cannot locate atlassian-user.xml");
            }
            SAXReader reader = new SAXReader();
            try {
                doc = reader.read(docIS);
            }
            catch (DocumentException e) {
                throw new ConfigurationException(e);
            }
            Node delegationNode = doc.selectSingleNode("//delegation");
            Node repositoriesNode = doc.selectSingleNode("//repositories");
            this.parseRepositories(repositoriesNode);
            if (delegationNode != null) {
                this.parseDelegation(delegationNode);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to load atlassian-user configuration: " + e.getMessage(), e);
        }
    }

    protected void parseRepositories(Node repositoriesNode) throws ConfigurationException, DocumentException, IOException {
        List repositoryElements = repositoriesNode.selectNodes("*");
        if (repositoryElements.isEmpty()) {
            throw new ConfigurationException("Nothing to init. There are no repositories specified.");
        }
        Iterator elementIterator = repositoryElements.iterator();
        while (elementIterator.hasNext()) {
            Element repositoryElement = (Element)elementIterator.next();
            String repositoryType = repositoryElement.getName();
            Map defaultComponentClassNames = this.defaultsParser.getDefaultClassesConfigForKey(repositoryType);
            Map defaultComponents = this.defaultsParser.getDefaultParameterConfigForKey(repositoryType);
            RepositoryIdentifier identifier = this.parseRepositoryIdentifier(repositoryElement);
            if (this.repositoryIdentifiers.contains(identifier)) {
                throw new ConfigurationException("Repository keys must be unique. Please check that you have not used the key '" + identifier.getKey() + "' more than once in your atlassian-user.xml file.");
            }
            HashMap componentClassNames = XMLConfigUtil.parseRepositoryElementForClassNames(repositoryElement);
            Map components = XMLConfigUtil.parseRepositoryElementForStringData(repositoryElement);
            Iterator componentClassNameIterator = defaultComponentClassNames.keySet().iterator();
            while (componentClassNameIterator.hasNext()) {
                String componentClassName = (String)componentClassNameIterator.next();
                if (componentClassNames.containsKey(componentClassName)) continue;
                componentClassNames.put(componentClassName, defaultComponentClassNames.get(componentClassName));
            }
            Iterator componentIterator = defaultComponents.keySet().iterator();
            while (componentIterator.hasNext()) {
                String componentName = (String)componentIterator.next();
                if (components.containsKey(componentName)) continue;
                components.put(componentName, defaultComponents.get(componentName));
            }
            RepositoryProcessor processor = this.instantiateProcessor(componentClassNames);
            DefaultRepositoryConfiguration configuration = new DefaultRepositoryConfiguration(identifier, processor, components, componentClassNames);
            if (this.isCachingEnabled(repositoryElement)) {
                configuration.setCacheConfiguration(this.parseCacheConfiguration());
            }
            this.repositoryIdentifiers.add(identifier);
            this.repositoryConfigurations.put(identifier, configuration);
        }
    }

    private RepositoryIdentifier parseRepositoryIdentifier(Element repositoryElement) {
        String key = repositoryElement.attributeValue("key");
        if (key == null) {
            throw new RuntimeException("Cannot specify repository without a key");
        }
        String name = repositoryElement.attributeValue("name", "Unnamed repository");
        return new DefaultRepositoryIdentifier(key, name);
    }

    private CacheConfiguration parseCacheConfiguration() throws DocumentException, IOException {
        Map classNames = this.defaultsParser.getDefaultClassesConfigForKey("cache");
        return new DefaultCacheConfiguration(classNames);
    }

    private boolean isCachingEnabled(Element repositoryElement) {
        String cache = repositoryElement.attributeValue("cache");
        return cache != null && cache.equalsIgnoreCase("true");
    }

    private void parseDelegation(Node delegationNode) {
        LinkedList<RepositoryIdentifier> delegationOrder = new LinkedList<RepositoryIdentifier>();
        Iterator keyIterator = delegationNode.selectNodes("key").iterator();
        block0: while (keyIterator.hasNext()) {
            String delegationKey = ((Element)keyIterator.next()).getText();
            Iterator identifierIterator = this.repositoryIdentifiers.iterator();
            while (identifierIterator.hasNext()) {
                RepositoryIdentifier identifier = (RepositoryIdentifier)identifierIterator.next();
                if (!delegationKey.equals(identifier.getKey())) continue;
                delegationOrder.add(identifier);
                continue block0;
            }
        }
        this.repositoryIdentifiers = delegationOrder;
    }

    private RepositoryProcessor instantiateProcessor(Map processorInfo) {
        String processorClassName = (String)processorInfo.get("processor");
        RepositoryProcessor processor = null;
        try {
            processor = (RepositoryProcessor)Class.forName(processorClassName).newInstance();
        }
        catch (Exception e) {
            log.error((Object)("Could not instantiate processor: " + e.getMessage()));
        }
        return processor;
    }

    public List getRepositoryConfigurations() {
        LinkedList result = new LinkedList();
        Iterator it = this.repositoryIdentifiers.iterator();
        while (it.hasNext()) {
            RepositoryIdentifier identifier = (RepositoryIdentifier)it.next();
            result.add(this.repositoryConfigurations.get(identifier));
        }
        return Collections.unmodifiableList(result);
    }
}

