package com.atlassian.user.util.migration;

/**
 *
 */
public interface MigrationProgressListener
{
    /**
     * called when user migration begins
     *
     * @param usersToMigrate the overall number of users to migrate.
     */
    void userMigrationStarted(int usersToMigrate);

    /**
     * called on each user migrated
     */
    void userMigrated();

    /**
     * called when user migration is complete
     */
    void userMigrationComplete();

    /**
     * called when group migration begins
     *
     * @param groupsToMigrate the overall number of groups to migrate
     */
    void groupMigrationStarted(int groupsToMigrate);

    /**
     * called on each group migration
     */
    void groupMigrated();

    /**
     * called when group migration is complete
     */
    void groupMigrationComplete();
}
