package com.atlassian.user.search.page;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/**
 * @deprecated use MergedListPager 
 */
public class MergedPager implements Pager
{
    private final Pager leftPager;
    private final Pager rightPager;

    /**
     * Do not instantiate a MergedPager directly, use {@link PagerFactory#getPager}
     */
    MergedPager(Pager pager1, Pager rightPager)
    {
        this.leftPager = pager1;
        this.rightPager = rightPager;
    }

    public boolean isEmpty()
    {
        return (leftPager == null || leftPager.isEmpty()) && (rightPager == null || rightPager.isEmpty());
    }

    public Iterator iterator()
    {
        if (leftPager == null && rightPager == null)
        {
            return new Iterator()
            {
                public void remove()
                {
                    throw new UnsupportedOperationException("This iterator does not support removal");
                }

                public boolean hasNext()
                {
                    return false;
                }

                public Object next()
                {
                    throw new NoSuchElementException("Empty iterator");
                }
            };
        }
        else if (leftPager != null && rightPager != null)
        {
            return new Iterator()
            {

                Iterator iter1 = leftPager.iterator();
                Iterator iter2 = rightPager.iterator();

                public void remove()
                {
                    throw new UnsupportedOperationException("This iterator does not support removal");
                }

                public boolean hasNext()
                {
                    return (iter1.hasNext() || iter2.hasNext());
                }

                public Object next()
                {
                    if (iter1.hasNext())
                        return iter1.next();
                    else if (iter2.hasNext())
                        return iter2.next();

                    throw new NoSuchElementException("Exhausted iterator");
                }
            };
        }
        else if (leftPager == null)
            return rightPager.iterator();
        else
            return leftPager.iterator();
    }

    public List getCurrentPage()
    {
        List currentPage = leftPager.getCurrentPage();

        // fetch some more if preload limit has not been reached
        for (Iterator iterator = rightPager.getCurrentPage().iterator(); iterator.hasNext();)
        {
            Object o = iterator.next();

            if (currentPage.size() < PRELOAD_LIMIT)
                currentPage.add(o);
            else
                break;
        }

        return currentPage;
    }

    public void nextPage()
    {
        leftPager.nextPage();

        if (leftPager.getCurrentPage().isEmpty())
            rightPager.nextPage();
    }

    public boolean onLastPage()
    {
        return (leftPager.getCurrentPage().isEmpty() && rightPager.onLastPage());
    }

    public void skipTo(int index) throws PagerException
    {
        leftPager.skipTo(index);

        if (leftPager.getIndex() != index)
            rightPager.skipTo(index - leftPager.getIndex() - leftPager.getCurrentPage().size());
    }

    /**
     * @return the current index position of the pager
     */
    public int getIndex()
    {
        return leftPager.getIndex() + rightPager.getIndex();
    }

    public int getIndexOfFirstItemInCurrentPage()
    {
        if (!(leftPager.getCurrentPage().isEmpty()))
            return leftPager.getIndexOfFirstItemInCurrentPage();

        return leftPager.getIndexOfFirstItemInCurrentPage() + rightPager.getIndexOfFirstItemInCurrentPage();
    }
}
