package com.atlassian.user.search;

import com.atlassian.user.search.page.Pager;

import java.util.HashMap;
import java.util.Set;

public abstract class AbstractSearchResult implements SearchResult
{
    protected HashMap repositoriesToResults;

    public AbstractSearchResult()
    {
        repositoriesToResults = new HashMap();
    }

    public void addToResults(String repositoryKey, Pager pager)
    {
        repositoriesToResults.put(repositoryKey, pager);
    }

    public Pager pager(String repoKey)
    {
        return (Pager) repositoriesToResults.get(repoKey);
    }

    /**
     * @return a list of {@link String} objects indcating the repositories with results in this
     *         object.
     */
    public Set repositoryKeyset()
    {
        return repositoriesToResults.keySet();
    }
}
