package com.atlassian.user.impl.ldap.repository;

import com.atlassian.user.impl.RepositoryException;

import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import java.util.Hashtable;

/**
 * This interface hold all information needed for the Atlassian user implementation to connect
 * to different LDAP systems.
 *
 * Accessors in the class can be divided into two groups - accessors for serving out connection properties
 * or accessors for serving mappings properties.
 *
 * Connection properties are used, obviously, for a connection.
 *
 * Any implementation of this interface should ensure that the behaviours return meaningful information,
 * whether for mapping or for connection. The global constants are there for use in a configuration file,
 * for example a properties file could be used holding connection properties, such as port=389.
 */
public interface LdapContextFactory
{

    //global constants for connection properties.
    public static final String HOST                         = "host";
    public static final String PORT                         = "port";
    public static final String SECURITY_PRINCIPAL           = "securityPrincipal";
    public static final String SECURITY_CREDENTIAL          = "securityCredential";
    public static final String SECURITY_AUTHENTICATION      = "securityAuthentication";
    public static final String PROVIDER_URL                 = "providerURL";
    public static final String JNDI_INITIAL_CONTEXT_FACTORY = "initialContextFactory";
    public static final String BATCH_SIZE                   = "batchSize";
    public static final String SECURITY_PROTOCOL            = "securityProtocol";
    public static final String TIME_TO_LIVE                 = "timeToLive";

    //global constants for mapping the User and Group objects to different LDAP schemata
    public static final String BASE_USER_NAMESPACE      = "baseUserNamespace";
    public static final String BASE_GROUP_NAMESPACE     = "baseGroupNamespace";
    public static final String USERNAME_ATTRIBUTE       = "usernameAttribute";
    public static final String GROUPNAME_ATTRIBUTE      = "groupnameAttribute";
    public static final String FIRSTNAME_ATTRIBUTE      = "firstnameAttribute";
    public static final String PASSWORD_ATTRIBUTE       = "passwordAttribute";
    public static final String SURNAME_ATTRIBUTE        = "surnameAttribute";
    public static final String EMAIL_ATTRIBUTE          = "emailAttribute";
    public static final String MEMBERSHIP_ATTRIBUTE     = "membershipAttribute";
    public static final String USER_SEARCH_ALL_DEPTHS   = "userSearchAllDepths";
    public static final String GROUP_SEARCH_ALL_DEPTHS  = "groupSearchAllDepths";
    public static final String GROUP_SEARCH_FILTER      = "groupSearchFilter";
    public static final String USER_SEARCH_FILTER       = "userSearchFilter";
    public static final String USE_UNQUALIFIED_USER_NAME_FOR_MEMBERSHIP_COMPARISON = "useUnqualifiedUsernameForMembershipComparison";

    /**
     * Returns a JNDI environment suitable for passing to {@link InitialDirContext#InitialDirContext(Hashtable)}.
     * The environment is suitable for a connection using all the configuration specified in the other properties
     * on this object.
     */
    Hashtable getJNDIEnv();

    /**
     * Returns a JNDI environment suitable for passing to {@link InitialDirContext#InitialContext(Hashtable)}.
     * The environment is suitable for a connection for authenticating the username and password provided.
     */
    Hashtable getAuthenticationJndiEnvironment(String userDN, String password);

    DirContext getLDAPContext() throws RepositoryException;
}
