package com.atlassian.user.impl.ldap.properties;

import javax.naming.Context;
import javax.naming.spi.InitialContextFactory;

/**
 * An interface for providing connection properties for connecting to an LDAP server via JNDI
 */
public interface LdapConnectionProperties
{
    /**
     * @return the user to be used for authenticating to the LDAP server
     * @see Context#SECURITY_PRINCIPAL
     */
    String getSecurityPrincipal();

    /**
     * @return the password to be used for authenticating to the LDAP server
     * @see Context#SECURITY_CREDENTIALS
     */
    String getSecurityCredential();

    /**
     * @return the URL of the LDAP server to connect to, typically in the form 'ldap://host:port'
     * @see Context#PROVIDER_URL
     */
    String getProviderURL();

    /**
     * @return the fully-qualified class name of the JNDI {@link InitialContextFactory} to use for opening the
     * connection
     * @see Context#INITIAL_CONTEXT_FACTORY
     */
    String getJNDIInitialContextFactoryIdentifier();

    /**
     * @return the batch size used for search results returned from the LDAP server
     * @see Context#BATCHSIZE
     */
    int getSearchBatchSize();

    /**
     * @return the type of security to use for authentication, for example "simple"
     * @see Context#SECURITY_AUTHENTICATION
     */
    String getSecurityAuthentication();

    /**
     * @return the type of security to use for the LDAP connection, for example "ssl"
     * @see Context#SECURITY_PROTOCOL
     */
    String getSecurityProtocol();

    /**
     * @return <code>true</code> if LDAP connection pooling is enabled, otherwise <code>false</code>.
     */
    boolean isPoolingOn();
}
