package com.atlassian.user.impl.ldap;

import net.sf.ldaptemplate.support.filter.Filter;
import com.atlassian.user.util.LDAPUtils;

/**
 * An explictly specified filter.
 *
 * The string supplied must already be escaped for both JNDI and LDAP -- it does *not* get filterEncoded.
 */
public class LiteralFilter implements Filter
{
    private String filter;

    public LiteralFilter(String filter)
    {
        if (!LDAPUtils.isValidFilter(filter))
        {
            throw new IllegalArgumentException("Invalid filter:" + filter);
        }
        this.filter = filter;
    }

    public String encode()
    {
        return filter;
    }

    public StringBuffer encode(StringBuffer stringBuffer)
    {
        return stringBuffer.append(filter);
    }
}
