package com.atlassian.user.impl.ldap;

import com.atlassian.user.impl.DefaultUser;

public class DefaultLDAPUser extends DefaultUser implements LDAPEntity
{
    /**
     * This is an escaped DN, ready to be passed to LDAP, but not escaped for JNDI
     */
    private transient String distinguishedName;

    public DefaultLDAPUser(String name, String distinguishedName)
    {
        super(name);
        this.distinguishedName = distinguishedName;
    }

    public String getDistinguishedName()
    {
        return distinguishedName;
    }

    public void setDistinguishedName(String distinguishedName)
    {
        this.distinguishedName = distinguishedName;
    }
}
