package com.atlassian.user.impl.hibernate.configuration;

import com.atlassian.user.configuration.*;

public class HibernateRepositoryProcessor extends DefaultRepositoryProcessor
{
    public RepositoryAccessor process(RepositoryConfiguration config) throws ConfigurationException
    {
        HibernateAccessor accessor;
        if (config.hasComponent(Configuration.ACCESSOR))
        {
            accessor = (HibernateAccessor) config.getComponent(Configuration.ACCESSOR);
        }
        else
        {
            accessor = (HibernateAccessor) createBean(Configuration.ACCESSOR, config);
        }
        config.addComponent(Configuration.HIBERNATE_SESSION_FACTORY, accessor.getSessionFactory());

        config.addComponent("hibernateProvider", createBean("hibernateProvider", config));

        if (!config.hasComponent(Configuration.EXTERNAL_ENTITY_DAO))
        {
            config.addComponent(Configuration.EXTERNAL_ENTITY_DAO,
                createBean(Configuration.EXTERNAL_ENTITY_DAO, config, false));
        }

        return super.process(config);
    }
}
