package com.atlassian.user.impl.hibernate;

import com.atlassian.user.ExternalEntity;
import com.atlassian.user.configuration.ConfigurationException;

import java.util.HashMap;

public interface ExternalEntityDAO
{
    ExternalEntity getExternalEntity(String externalEntityName);

    void saveExternalEntity(ExternalEntity externalEntity);

    void init(HashMap args) throws ConfigurationException;

    /**
     * Remove the named external taking no action if the external entity can't be found.
     * @param externalEntityName the name of the external entity
     */
    void removeExternalEntity(String externalEntityName);
}
