package com.atlassian.user.impl.hibernate;

import com.atlassian.user.ExternalEntity;
import com.atlassian.user.configuration.Configuration;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.util.InitializationCheck;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.orm.hibernate.SessionFactoryUtils;
import org.springframework.orm.hibernate.support.HibernateDaoSupport;

import java.util.HashMap;
import java.util.Iterator;

public class DefaultExternalEntityDAO extends HibernateDaoSupport implements ExternalEntityDAO
{
    public static final String EXTERNAL_ENTITY_PREFIX = "ATLUSER_";

    public ExternalEntity getExternalEntity(final String externalEntityName)
    {
        return (ExternalEntity) getHibernateTemplate().execute(new HibernateCallback()
        {
            public Object doInHibernate(Session session) throws HibernateException
            {
                Query queryObject = session.getNamedQuery("atluser.externalEntity_findExternalEntity");
                SessionFactoryUtils.applyTransactionTimeout(queryObject, getSessionFactory());

                Iterator iterator = queryObject.setString("externalEntityName", externalEntityName).iterate();
                if (iterator.hasNext())
                    return iterator.next();
                else
                    return null;
            }
        });
    }

    public void removeExternalEntity(String externalEntityName)
    {
        getHibernateTemplate().delete(getExternalEntity(externalEntityName));
        getHibernateTemplate().flush();
    }

    public void saveExternalEntity(ExternalEntity externalEntity)
    {
        getHibernateTemplate().save(externalEntity);
        getHibernateTemplate().flush();
    }

    public void init(HashMap args) throws ConfigurationException
    {
        SessionFactory sessionFactory = (SessionFactory) args.get(Configuration.HIBERNATE_SESSION_FACTORY);
        InitializationCheck.validateArgs(args, new String[]{Configuration.HIBERNATE_SESSION_FACTORY}, this);

        setSessionFactory(sessionFactory);
    }
}
