package com.atlassian.user.impl.delegation.repository;

import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.configuration.Configuration;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.util.InitializationCheck;

import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.HashMap;

public class DelegatingRepository implements RepositoryIdentifier
{
    public transient static final String DELEGATING = "Delegating Repository: ";
    private transient  List repositories;

    public DelegatingRepository(){}

    public DelegatingRepository(RepositoryIdentifier repo1, RepositoryIdentifier repo2)
    {
        repositories = new ArrayList();
        repositories.add(repo1);
        repositories.add(repo2);
    }

    public DelegatingRepository(List repositories)
    {
        this.repositories = repositories;
    }

    public String getKey()
    {
        StringBuffer key = new StringBuffer(DELEGATING);

        Iterator iter = repositories.iterator();

        while (iter.hasNext())
        {
            RepositoryIdentifier r = (RepositoryIdentifier) iter.next();
            key.append(r.getKey());
            key.append(" ");
        }

        return key.toString();
    }

    public String getName()
    {
        StringBuffer name = new StringBuffer(DELEGATING);

        Iterator iter = repositories.iterator();

        while (iter.hasNext())
        {
            RepositoryIdentifier r = (RepositoryIdentifier) iter.next();
            name.append(r.getName());
            name.append(" ");
        }

        return name.toString();
    }

    public String getDescription()
    {
        return DELEGATING;
    }

    public void init(HashMap args) throws ConfigurationException
    {
        repositories = (List) args.get(Configuration.REPOSITORIES);
        InitializationCheck.validateArgs(args, new String[]{Configuration.REPOSITORIES}, this);
    }

    public List getRepositories()
    {
        return repositories;    
    }
}
