package com.atlassian.user.impl.delegation;

import com.atlassian.user.GroupManager;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/**
 * Group manager with a delegation order of a simple list, where the group managers are
 * tried in the iteration order of the list.
 */
public class DelegatingListGroupManager extends DelegatingGroupManagerTemplate
{
    /** List of {@link GroupManager}s. */
    private final List groupManagers;

    public DelegatingListGroupManager(List groupManagers)
    {
        this.groupManagers = groupManagers;
    }

    protected Iterator getGroupManagersIterator()
    {
        return groupManagers.iterator();
    }

    /**
     * @return an unmodifiable list of {@link GroupManager}s which this manager delegates to,
     * in the order of delegation.
     */
    public List getGroupManagers()
    {
        return Collections.unmodifiableList(groupManagers);
    }
}
