package com.atlassian.user.impl.cache;

import java.util.List;

public interface CacheManager
{
    /**
     * Retrieve the cache with a particular name
     *
     * @param cacheName the unique name of the cache
     * @return the appropriate cache
     */
    Cache getCache(String cacheName);

    /**
     * Flush the contents of all caches registered with the cache manager
     */
    void flushCaches();

    /**
     * Set the caches that should not be flushed when flushCaches() is called
     *
     * @param cacheNames the names of the cache, each a {@link String}
     */
    void setNonFlushableCaches(List/*<String>*/ cacheNames);
}
