/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.util.migration;

import com.atlassian.user.User;
import com.atlassian.user.impl.DefaultUser;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

public class OSUserDao
extends JdbcDaoSupport {
    private static final String USERNAME_COL = "username";
    private static final String ID_COL = "id";
    private static final String PASSWORD_COL = "passwd";
    private static final String KEY_COL = "entity_key";
    private static final String VALUE_COL = "string_val";
    private static final String OSUSER_TABLE = "os_user";
    private static final String OSPROPERTYSET_TABLE = "OS_PROPERTYENTRY";

    OSUserDao(DataSource dataSource) {
        this.setDataSource(dataSource);
    }

    Map findAllUsers() {
        final HashMap users = new HashMap();
        this.getJdbcTemplate().query("select * from os_user", new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Long id = new Long(rs.getLong(OSUserDao.ID_COL));
                DefaultUser user = new DefaultUser(rs.getString(OSUserDao.USERNAME_COL));
                user.setPassword(rs.getString(OSUserDao.PASSWORD_COL));
                users.put(id, user);
            }
        });
        this.getJdbcTemplate().query("SELECT * FROM OS_PROPERTYENTRY WHERE entity_name='OSUser_user' AND ( entity_key='fullName' OR entity_key='email')", new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                Long id = new Long(resultSet.getLong("entity_id"));
                User user = (User)users.get(id);
                if (user != null) {
                    String key = resultSet.getString(OSUserDao.KEY_COL);
                    String value = resultSet.getString(OSUserDao.VALUE_COL);
                    if ("fullName".equals(key)) {
                        user.setFullName(value);
                    } else if ("email".equals(key)) {
                        user.setEmail(value);
                    }
                }
            }
        });
        return users;
    }
}

