/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.util.migration;

import com.atlassian.user.EntityException;
import com.atlassian.user.ExternalEntity;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.configuration.DefaultDelegationAccessor;
import com.atlassian.user.configuration.DelegationAccessor;
import com.atlassian.user.configuration.RepositoryAccessor;
import com.atlassian.user.impl.DefaultUser;
import com.atlassian.user.impl.RepositoryException;
import com.atlassian.user.impl.hibernate.DefaultHibernateUser;
import com.atlassian.user.impl.osuser.OSUAccessor;
import com.atlassian.user.impl.osuser.OSUUserManager;
import com.atlassian.user.util.migration.EntityMigrator;
import com.atlassian.user.util.migration.MigrationProgressListener;
import com.atlassian.user.util.migration.MigratorConfiguration;
import com.atlassian.user.util.migration.OSUserDao;
import com.opensymphony.user.provider.AccessProvider;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Logger;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class OSUEntityMigrator
implements EntityMigrator {
    private static final Logger log = Logger.getLogger(OSUEntityMigrator.class);
    private static final String OSUSER_REPOSITORY_KEY = "osuserRepository";
    private UserManager targetUserManager;
    private GroupManager targetGroupManager;
    private AccessProvider osAccessProvider;
    private final SessionFactory sessionFactory;

    public OSUEntityMigrator(RepositoryAccessor osuserRepositoryAccessor, RepositoryAccessor repositoryAccessor, SessionFactory sessionFactory) {
        if (osuserRepositoryAccessor == null) {
            throw new IllegalArgumentException("osuserRepositoryAccessor is required.");
        }
        if (repositoryAccessor == null) {
            throw new IllegalArgumentException("targetRepositoryAccessor is required.");
        }
        if (sessionFactory == null) {
            throw new IllegalArgumentException("sessionFactory is required.");
        }
        this.sessionFactory = sessionFactory;
        DelegationAccessor targetRepositoryAccessor = this.getNonOSUserRepositoryAccessor(repositoryAccessor);
        if (!targetRepositoryAccessor.getRepositoryAccessors().isEmpty()) {
            UserManager osUserManager = osuserRepositoryAccessor.getUserManager();
            if (osUserManager == null) {
                throw new IllegalArgumentException("osUserManager is required.");
            }
            OSUAccessor osuAccessor = ((OSUUserManager)osUserManager).getAccessor();
            if (osuAccessor == null) {
                throw new IllegalArgumentException("osuAccessor is required.");
            }
            this.osAccessProvider = osuAccessor.getAccessProvider();
            if (this.osAccessProvider == null) {
                throw new IllegalArgumentException("osAccessProvider is required.");
            }
            this.targetUserManager = targetRepositoryAccessor.getUserManager();
            this.targetGroupManager = targetRepositoryAccessor.getGroupManager();
            if (this.targetUserManager == null) {
                throw new IllegalArgumentException("userManager is required.");
            }
            if (this.targetGroupManager == null) {
                throw new IllegalArgumentException("groupManager is required.");
            }
        }
    }

    private DelegationAccessor getNonOSUserRepositoryAccessor(RepositoryAccessor repositoryAccessor) {
        DefaultDelegationAccessor nonOSUserDelegationAccessor = new DefaultDelegationAccessor();
        if (repositoryAccessor instanceof DelegationAccessor) {
            DelegationAccessor delegationAccessor = (DelegationAccessor)repositoryAccessor;
            for (RepositoryAccessor accessor : delegationAccessor.getRepositoryAccessors()) {
                if (OSUSER_REPOSITORY_KEY.equals(accessor.getIdentifier().getKey())) continue;
                nonOSUserDelegationAccessor.addRepositoryAccessor(accessor);
            }
            return nonOSUserDelegationAccessor;
        }
        if (!OSUSER_REPOSITORY_KEY.equals(repositoryAccessor.getIdentifier().getKey())) {
            nonOSUserDelegationAccessor.addRepositoryAccessor(repositoryAccessor);
        }
        return nonOSUserDelegationAccessor;
    }

    @Override
    public void migrate(MigratorConfiguration config, MigrationProgressListener progressListener) throws EntityException {
        if (this.targetUserManager == null) {
            throw new RepositoryException("No non OSUser repository configured. Cannot perform migration.");
        }
        DataSource dataSource = this.getDataSource();
        OSUserDao osUserDao = new OSUserDao(dataSource);
        Map users = osUserDao.findAllUsers();
        HashSet<String> existingUsernames = new HashSet<String>();
        HashSet<String> nonExistingUsernames = new HashSet<String>();
        progressListener.userMigrationStarted(users.size());
        for (Map.Entry userEntry : users.entrySet()) {
            Long osUserId = (Long)userEntry.getKey();
            User user = (User)userEntry.getValue();
            if (this.userExists(this.targetUserManager, user)) {
                existingUsernames.add(user.getName());
            } else {
                nonExistingUsernames.add(user.getName());
                this.addUser(this.targetUserManager, (DefaultUser)user);
            }
            try {
                this.migratePropertySet(osUserId, user);
            }
            catch (EntityException e) {
                log.error((Object)("Error migrating property set for user: " + user + " with id: " + osUserId), (Throwable)e);
            }
            progressListener.userMigrated();
        }
        progressListener.userMigrationComplete();
        List groups = this.osAccessProvider.list();
        progressListener.groupMigrationStarted(groups.size());
        for (String groupName : groups) {
            Group migratedGroup = this.getOrCreateGroup(groupName);
            List members = this.osAccessProvider.listUsersInGroup(groupName);
            for (String member : members) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Adding member <" + member + "> to group <" + groupName + ">"));
                }
                if (!nonExistingUsernames.contains(member) && (!existingUsernames.contains(member) || !config.isMigrateMembershipsForExistingUsers())) continue;
                this.targetGroupManager.addMembership(migratedGroup, this.targetUserManager.getUser(member));
            }
            progressListener.groupMigrated();
        }
        progressListener.groupMigrationComplete();
    }

    private void migratePropertySet(Long userId, User user) throws EntityException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Migrating properties for <" + user.getName() + ">"));
        }
        User targetUser = this.targetUserManager.getUser(user.getName());
        String osUserId = String.valueOf(userId);
        final String entityName = this.getEntityName(targetUser);
        final String entityId = this.getEntityId(targetUser);
        final JdbcTemplate template = new JdbcTemplate(this.getDataSource());
        template.query("SELECT * FROM OS_PROPERTYENTRY WHERE ENTITY_NAME = 'OSUser_user' AND ENTITY_ID = ? AND ENTITY_KEY <> 'fullName' AND ENTITY_KEY <> 'email'", (Object[])new String[]{osUserId}, new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                template.update("INSERT INTO OS_PROPERTYENTRY (ENTITY_NAME,ENTITY_ID,ENTITY_KEY,KEY_TYPE,BOOLEAN_VAL,DOUBLE_VAL,STRING_VAL,LONG_VAL,INT_VAL,DATE_VAL) VALUES (?,?,?,?,?,?,?,?,?,?)", new Object[]{entityName, entityId, resultSet.getString("ENTITY_KEY"), new Integer(resultSet.getInt("KEY_TYPE")), resultSet.getBoolean("BOOLEAN_VAL"), new Double(resultSet.getDouble("DOUBLE_VAL")), resultSet.getString("STRING_VAL"), new Long(resultSet.getLong("LONG_VAL")), new Integer(resultSet.getInt("INT_VAL")), resultSet.getTimestamp("DATE_VAL")});
            }
        });
    }

    private String getEntityName(User user) throws EntityException {
        if (user instanceof DefaultHibernateUser) {
            return "LOC_" + user.getName();
        }
        if (user instanceof ExternalEntity) {
            return "EXT_" + user.getName();
        }
        throw new EntityException("Could not determine entityName for user: " + user + " of type: " + (user != null ? user.getClass().getName() : "unkown"));
    }

    private String getEntityId(User user) throws EntityException {
        if (user instanceof DefaultHibernateUser) {
            return String.valueOf(((DefaultHibernateUser)user).getId());
        }
        if (user instanceof ExternalEntity) {
            return String.valueOf(((ExternalEntity)((Object)user)).getId());
        }
        throw new EntityException("Could not find id for user: " + user + " of type: " + (user != null ? user.getClass().getName() : "unkown"));
    }

    private void addUser(UserManager userManager, DefaultUser user) throws EntityException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Adding user <" + user.getName() + ">"));
        }
        User newUser = userManager.createUser(user.getName());
        newUser.setFullName(user.getFullName());
        newUser.setEmail(user.getEmail());
        newUser.setPassword(user.getPassword());
        userManager.saveUser(newUser);
    }

    private Group getOrCreateGroup(String groupName) throws EntityException {
        Group group = this.targetGroupManager.getGroup(groupName);
        if (group == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Creating group <" + groupName + ">"));
            }
            group = this.targetGroupManager.createGroup(groupName);
        }
        return group;
    }

    private boolean userExists(UserManager userManager, User user) throws EntityException {
        return user != null && userManager.getUser(user.getName()) != null;
    }

    private DataSource getDataSource() {
        Connection conn;
        Session hibernateSession = SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true);
        try {
            conn = hibernateSession.connection();
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
        return new SingleConnectionDataSource(conn, true);
    }
}

