/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.search.page;

import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.PagerException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Category;

public class MergedListPager
implements Pager {
    private static final Category log = Category.getInstance(MergedListPager.class);
    private List pagers;
    private int combinedIndex;
    public Pager currentPager;
    private List currentPage;
    private int indexOfFirstItemInCurrentPage;
    private boolean onLastPage = false;

    MergedListPager(List pagers) {
        this.pagers = pagers;
    }

    @Override
    public boolean isEmpty() {
        for (Pager pager : this.pagers) {
            if (pager.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Iterator iterator() {
        if (this.pagers == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return new MergedListIterator(this.pagers);
    }

    public List getCurrentPage() {
        if (this.currentPage == null) {
            this.currentPage = new ArrayList();
            this.indexOfFirstItemInCurrentPage = this.combinedIndex;
            Iterator iterator = this.iterator();
            while (iterator.hasNext() && this.currentPage.size() < 100) {
                this.currentPage.add(iterator.next());
                ++this.combinedIndex;
            }
            if (this.currentPage.size() < 100 || !this.iterator().hasNext()) {
                this.onLastPage = true;
            }
        }
        return this.currentPage;
    }

    @Override
    public void nextPage() {
        try {
            this.skipTo(this.combinedIndex + (this.currentPage == null ? 100 : 0));
        }
        catch (PagerException e) {
            log.error((Object)"Erroring calling nextPage()", (Throwable)e);
        }
    }

    @Override
    public boolean onLastPage() {
        return this.onLastPage;
    }

    @Override
    public void skipTo(int index) throws PagerException {
        if (index < this.combinedIndex) {
            throw new PagerException("Cannot run the index back to [" + index + "] from [" + this.combinedIndex + "]");
        }
        while (this.combinedIndex < index) {
            this.iterator().next();
            ++this.combinedIndex;
        }
        this.currentPage = null;
        this.getCurrentPage();
    }

    @Override
    public int getIndex() {
        return this.combinedIndex;
    }

    @Override
    public int getIndexOfFirstItemInCurrentPage() {
        this.getCurrentPage();
        return this.indexOfFirstItemInCurrentPage;
    }

    private class MergedListIterator
    implements Iterator {
        private List iterators = new ArrayList();

        public MergedListIterator(List listOfPagers) {
            for (Pager pager : listOfPagers) {
                this.iterators.add(pager.iterator());
            }
        }

        private Iterator getCurrentIterator() {
            for (int i = 0; i < this.iterators.size(); ++i) {
                Iterator iterator = (Iterator)this.iterators.get(i);
                if (!iterator.hasNext()) continue;
                return iterator;
            }
            return Collections.EMPTY_LIST.iterator();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator does not support removal");
        }

        @Override
        public boolean hasNext() {
            return this.getCurrentIterator().hasNext();
        }

        public Object next() {
            Object nextElement = this.getCurrentIterator().next();
            if (!this.hasNext()) {
                MergedListPager.this.onLastPage = true;
            }
            return nextElement;
        }
    }
}

