/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.memory.properties;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.properties.PropertySetFactory;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import java.util.HashMap;
import java.util.Map;

public class MemoryPropertySetFactory
implements PropertySetFactory {
    private static final String MEMORY_PROPERTY_SET = "memory";
    private final Map propertySets = new HashMap();

    @Override
    public PropertySet getPropertySet(Entity entity) throws EntityException {
        if (entity == null) {
            throw new IllegalArgumentException("Cannot generate a propertyset for a null entity");
        }
        PropertySet propertySet = (PropertySet)this.propertySets.get(entity.getName());
        if (propertySet != null) {
            return propertySet;
        }
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("entityName", "_" + entity.getName());
        propertySet = PropertySetManager.getInstance((String)MEMORY_PROPERTY_SET, args);
        this.propertySets.put(entity.getName(), propertySet);
        return propertySet;
    }
}

