/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.memory;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.impl.DefaultUser;
import com.atlassian.user.impl.DuplicateEntityException;
import com.atlassian.user.impl.memory.provider.MemoryProvider;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.security.password.PasswordEncryptor;

public class MemoryUserManager
implements UserManager {
    private final MemoryProvider provider;
    private final RepositoryIdentifier repository;
    private final PasswordEncryptor passwordEncryptor;

    public MemoryUserManager(RepositoryIdentifier repository, MemoryProvider provider, PasswordEncryptor passwordEncryptor) {
        this.provider = provider;
        this.repository = repository;
        this.passwordEncryptor = passwordEncryptor;
    }

    @Override
    public Pager getUsers() {
        return this.provider.getUsers();
    }

    @Override
    public Pager getUserNames() throws EntityException {
        return this.provider.getUserNames();
    }

    @Override
    public User getUser(String username) {
        return this.provider.getUser(username);
    }

    @Override
    public User createUser(String username) throws EntityException {
        User existingUser = this.provider.getUser(username);
        if (existingUser != null) {
            throw new DuplicateEntityException("User already exists: [" + existingUser + "] in " + this.getRepository(existingUser));
        }
        DefaultUser user = new DefaultUser(username);
        this.provider.addUser(user);
        return user;
    }

    @Override
    public void alterPassword(User user, String plainTextPass) throws EntityException {
        user.setPassword(this.passwordEncryptor.encrypt(plainTextPass));
    }

    @Override
    public void removeUser(User user) throws EntityException {
        if (this.provider.getUser(user.getName()) == null) {
            throw new IllegalArgumentException("User can not be found in this user manager: [" + user + "]");
        }
        this.provider.removeUser(user);
    }

    @Override
    public boolean isReadOnly(User user) {
        return this.getUser(user.getName()) == null;
    }

    public PasswordEncryptor getPasswordEncryptor(User user) throws EntityException {
        return this.passwordEncryptor;
    }

    @Override
    public void saveUser(User user) throws EntityException {
    }

    @Override
    public RepositoryIdentifier getIdentifier() {
        return this.repository;
    }

    @Override
    public RepositoryIdentifier getRepository(Entity entity) throws EntityException {
        if (this.getUser(entity.getName()) == null) {
            return null;
        }
        return this.repository;
    }

    @Override
    public boolean isCreative() {
        return true;
    }
}

