/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.ldap.search.query;

import com.atlassian.user.EntityException;
import com.atlassian.user.impl.RepositoryException;
import com.atlassian.user.impl.ldap.DefaultLDAPGroupFactory;
import com.atlassian.user.impl.ldap.LDAPGroupFactory;
import com.atlassian.user.impl.ldap.LDAPUserFactory;
import com.atlassian.user.impl.ldap.LiteralFilter;
import com.atlassian.user.impl.ldap.adaptor.LDAPGroupAdaptor;
import com.atlassian.user.impl.ldap.properties.LdapMembershipProperties;
import com.atlassian.user.impl.ldap.properties.LdapSearchProperties;
import com.atlassian.user.impl.ldap.repository.LdapContextFactory;
import com.atlassian.user.impl.ldap.search.DefaultLDAPUserAdaptor;
import com.atlassian.user.impl.ldap.search.LDAPPagerInfo;
import com.atlassian.user.impl.ldap.search.LDAPUserAdaptor;
import com.atlassian.user.impl.ldap.search.LdapFilterFactory;
import com.atlassian.user.impl.ldap.search.page.LDAPEntityPager;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.DefaultSearchResult;
import com.atlassian.user.search.SearchResult;
import com.atlassian.user.search.query.BooleanQuery;
import com.atlassian.user.search.query.EmailTermQuery;
import com.atlassian.user.search.query.EntityQueryParser;
import com.atlassian.user.search.query.FullNameTermQuery;
import com.atlassian.user.search.query.GroupNameTermQuery;
import com.atlassian.user.search.query.GroupsOfUserTwoTermQuery;
import com.atlassian.user.search.query.Query;
import com.atlassian.user.search.query.QueryContext;
import com.atlassian.user.search.query.TermQuery;
import com.atlassian.user.search.query.UserNameTermQuery;
import com.atlassian.user.search.query.UsersInGroupTwoTermQuery;
import com.atlassian.util.profiling.UtilTimerStack;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import net.sf.ldaptemplate.support.LdapEncoder;

public class LDAPEntityQueryParser
implements EntityQueryParser {
    public static final String OPEN_PARAN = "(";
    public static final String CLOSE_PARAN = ")";
    public static final String EQ = "=";
    public static final String AND = "&";
    public static final String OR = "|";
    public static final String WILDCARD = "*";
    private final LdapContextFactory repository;
    private final LDAPUserAdaptor userAdaptor;
    private final LDAPGroupAdaptor groupAdaptor;
    private final LDAPGroupFactory groupFactory;
    private final LDAPUserFactory userFactory;
    private final RepositoryIdentifier repositoryIdentifier;
    private final LdapSearchProperties searchProperties;
    private final LdapMembershipProperties membershipProperties;

    public LDAPEntityQueryParser(LdapContextFactory repository, LDAPGroupAdaptor groupAdaptor, RepositoryIdentifier repositoryIdentifier, LDAPUserFactory userFactory, LdapSearchProperties searchProperties, LdapMembershipProperties membershipProperties, LdapFilterFactory filterFactory) {
        this.repositoryIdentifier = repositoryIdentifier;
        this.repository = repository;
        this.groupAdaptor = groupAdaptor;
        this.userFactory = userFactory;
        this.userAdaptor = new DefaultLDAPUserAdaptor(this.repository, searchProperties, filterFactory);
        this.groupFactory = new DefaultLDAPGroupFactory(searchProperties, membershipProperties);
        this.searchProperties = searchProperties;
        this.membershipProperties = membershipProperties;
    }

    @Override
    public SearchResult findUsers(Query query) throws EntityException {
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_findUsers"));
        }
        String parsedQuery = null;
        parsedQuery = this.directQuery(query, parsedQuery);
        LDAPPagerInfo info = this.userAdaptor.search(new LiteralFilter(parsedQuery));
        LDAPEntityPager iter = new LDAPEntityPager(this.repository, this.userFactory, info);
        DefaultSearchResult searchResult = new DefaultSearchResult(iter, this.repositoryIdentifier.getKey());
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_findUsers"));
        }
        return searchResult;
    }

    @Override
    public SearchResult findGroups(Query query) throws EntityException {
        String parsedQuery = this.directQuery(query, null);
        LDAPPagerInfo info = this.groupAdaptor.search(new LiteralFilter(parsedQuery));
        LDAPEntityPager pager = new LDAPEntityPager(this.repository, this.groupFactory, info);
        return new DefaultSearchResult(pager, this.repositoryIdentifier.getKey());
    }

    @Override
    public SearchResult findUsers(Query query, QueryContext context) throws EntityException {
        SearchResult result = null;
        if (context.getRepositoryKeys().contains(this.repositoryIdentifier.getKey()) || context.getRepositoryKeys().contains("_all_repositories_")) {
            result = this.findUsers(query);
        }
        if (result == null) {
            return null;
        }
        return result;
    }

    @Override
    public SearchResult findGroups(Query query, QueryContext context) throws EntityException {
        SearchResult result = null;
        if (context.getRepositoryKeys().contains(this.repositoryIdentifier.getKey()) || context.getRepositoryKeys().contains("_all_repositories_")) {
            result = this.findGroups(query);
        }
        if (result == null) {
            return null;
        }
        return result;
    }

    private String directQuery(Query query, String defaultQuery) throws EntityException {
        if (query instanceof TermQuery) {
            StringBuffer parsedQueryStringBuffer = this.parseQuery((TermQuery)query);
            return parsedQueryStringBuffer.toString();
        }
        if (query instanceof BooleanQuery) {
            return this.parseQuery((BooleanQuery)query).toString();
        }
        return defaultQuery;
    }

    public StringBuffer parseQuery(BooleanQuery query) throws EntityException {
        StringBuffer parsedClause = new StringBuffer();
        parsedClause.append(OPEN_PARAN);
        if (query.isAND()) {
            parsedClause.append(AND);
        } else {
            parsedClause.append(OR);
        }
        for (Query foundQuery : query.getQueries()) {
            if (foundQuery instanceof BooleanQuery) {
                parsedClause.append(this.parseQuery((BooleanQuery)foundQuery));
                continue;
            }
            parsedClause.append(this.parseQuery((TermQuery)foundQuery));
        }
        parsedClause.append(CLOSE_PARAN);
        return parsedClause;
    }

    public StringBuffer parseQuery(TermQuery q) throws EntityException {
        StringBuffer parsedQuery = null;
        if (q instanceof UserNameTermQuery) {
            parsedQuery = this.parseTermQuery(q, this.searchProperties.getUsernameAttribute());
        } else if (q instanceof GroupNameTermQuery) {
            parsedQuery = this.parseTermQuery(q, this.searchProperties.getGroupnameAttribute());
        } else if (q instanceof EmailTermQuery) {
            parsedQuery = this.parseTermQuery(q, this.searchProperties.getEmailAttribute());
        } else if (q instanceof FullNameTermQuery) {
            parsedQuery = this.parseFullNameTermQuery(q);
        } else if (q instanceof UsersInGroupTwoTermQuery) {
            parsedQuery = this.parseMemberNamesInGroupTermQuery();
        } else if (q instanceof GroupsOfUserTwoTermQuery) {
            parsedQuery = this.parseGroupsOfUserTwoTermQuery((GroupsOfUserTwoTermQuery)((Object)q));
        }
        return parsedQuery;
    }

    private StringBuffer parseFullNameTermQuery(TermQuery q) {
        StringBuffer query = new StringBuffer();
        query.insert(0, OR);
        query.insert(0, OPEN_PARAN);
        query.append(this.parseTermQuery(q, this.searchProperties.getFirstnameAttribute()));
        query.append(this.parseTermQuery(q, this.searchProperties.getSurnameAttribute()));
        query.append(CLOSE_PARAN);
        return query;
    }

    private StringBuffer parseMemberNamesInGroupTermQuery() throws EntityException {
        if (!this.membershipProperties.isMembershipAttributeOnGroup()) {
            throw new UnsupportedOperationException();
        }
        LDAPPagerInfo pagerInfo = this.groupAdaptor.getGroupEntries(null);
        NamingEnumeration enume = pagerInfo.getNamingEnumeration();
        return this.parseMembershipAttributesForGroupNames(enume);
    }

    private StringBuffer parseGroupsOfUserTwoTermQuery(GroupsOfUserTwoTermQuery q) throws EntityException {
        String userPattern = null;
        UserNameTermQuery uQuery = q.getUserNameTermQuery();
        if (uQuery.isMatchingSubstring()) {
            if (uQuery.getMatchingRule().equals("starts_with")) {
                userPattern = uQuery.getTerm() + WILDCARD;
            } else if (uQuery.getMatchingRule().equals("ends_with")) {
                userPattern = WILDCARD + uQuery.getTerm();
            } else if (uQuery.getMatchingRule().equals("contains")) {
                userPattern = WILDCARD + uQuery.getTerm() + WILDCARD;
            }
        } else {
            userPattern = uQuery.getTerm();
        }
        LDAPPagerInfo pagerInfo = this.groupAdaptor.getGroupEntriesViaMembership(userPattern);
        StringBuffer groupQuery = this.membershipProperties.isMembershipAttributeOnGroup() ? this.buildQueryForUsersInStaticGroups(pagerInfo.getNamingEnumeration()) : this.buildQueryForUsersInDynamicGroups(pagerInfo.getNamingEnumeration());
        return groupQuery;
    }

    private StringBuffer buildQueryForUsersInDynamicGroups(NamingEnumeration enume) throws EntityException {
        StringBuffer parsedQuery = null;
        while (enume.hasMoreElements()) {
            javax.naming.directory.SearchResult result = (javax.naming.directory.SearchResult)enume.nextElement();
            Attributes attrs = result.getAttributes();
            Attribute attr = attrs.get(this.membershipProperties.getMembershipAttribute());
            if (attr == null) {
                return null;
            }
            try {
                NamingEnumeration<?> membershipEnume = attr.getAll();
                while (membershipEnume.hasMoreElements()) {
                    boolean wrapping = false;
                    if (parsedQuery == null) {
                        parsedQuery = new StringBuffer();
                    } else {
                        parsedQuery.insert(0, OR);
                        parsedQuery.insert(0, OPEN_PARAN);
                        wrapping = true;
                    }
                    parsedQuery.append(OPEN_PARAN);
                    parsedQuery.append(((String)membershipEnume.nextElement()).split(",")[0]);
                    parsedQuery.append(CLOSE_PARAN);
                    if (!wrapping) continue;
                    parsedQuery.append(CLOSE_PARAN);
                }
            }
            catch (Exception e) {
                throw new RepositoryException(e);
            }
        }
        return parsedQuery;
    }

    private StringBuffer buildQueryForUsersInStaticGroups(NamingEnumeration enume) throws EntityException {
        StringBuffer parsedQuery = null;
        while (enume.hasMoreElements()) {
            javax.naming.directory.SearchResult result = (javax.naming.directory.SearchResult)enume.nextElement();
            Attributes attrs = result.getAttributes();
            Attribute attr = attrs.get(this.searchProperties.getGroupnameAttribute());
            if (attr == null) {
                return null;
            }
            try {
                NamingEnumeration<?> membershipEnume = attr.getAll();
                while (membershipEnume.hasMoreElements()) {
                    boolean wrapping = false;
                    if (parsedQuery == null) {
                        parsedQuery = new StringBuffer();
                    } else {
                        parsedQuery.insert(0, OR);
                        parsedQuery.insert(0, OPEN_PARAN);
                        wrapping = true;
                    }
                    parsedQuery.append(OPEN_PARAN);
                    parsedQuery.append(this.searchProperties.getGroupnameAttribute());
                    parsedQuery.append(EQ);
                    parsedQuery.append(((String)membershipEnume.nextElement()).split(",")[0]);
                    parsedQuery.append(CLOSE_PARAN);
                    if (!wrapping) continue;
                    parsedQuery.append(CLOSE_PARAN);
                }
            }
            catch (Exception e) {
                throw new RepositoryException(e);
            }
        }
        return parsedQuery;
    }

    private StringBuffer parseMembershipAttributesForGroupNames(NamingEnumeration enume) {
        StringBuffer parsedQuery = null;
        while (enume.hasMoreElements()) {
            javax.naming.directory.SearchResult result = (javax.naming.directory.SearchResult)enume.nextElement();
            Attributes attrs = result.getAttributes();
            Attribute attr = this.membershipProperties.isMembershipAttributeOnGroup() ? attrs.get(this.membershipProperties.getMembershipAttribute()) : attrs.get(this.searchProperties.getGroupnameAttribute());
            try {
                if (parsedQuery == null) {
                    parsedQuery = this.parseMembershipAttributeForGroupNames(attr);
                    continue;
                }
                parsedQuery.insert(0, "(|");
                parsedQuery = parsedQuery.append(this.parseMembershipAttributeForGroupNames(attr));
                parsedQuery.append(CLOSE_PARAN);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return parsedQuery;
    }

    private StringBuffer parseMembershipAttributeForGroupNames(Attribute attr) throws NamingException {
        if (attr == null) {
            return null;
        }
        StringBuffer parsedQuery = null;
        NamingEnumeration<?> membershipEnume = attr.getAll();
        while (membershipEnume.hasMoreElements()) {
            boolean wrapping = false;
            if (parsedQuery == null) {
                parsedQuery = new StringBuffer();
            } else {
                parsedQuery.insert(0, OR);
                parsedQuery.insert(0, OPEN_PARAN);
                wrapping = true;
            }
            if (this.membershipProperties.isMembershipAttributeOnGroup()) {
                parsedQuery.append(OPEN_PARAN);
                parsedQuery.append(((String)membershipEnume.nextElement()).split(",")[0]);
                parsedQuery.append(CLOSE_PARAN);
            } else {
                parsedQuery.append(OPEN_PARAN);
                parsedQuery.append(this.searchProperties.getGroupnameAttribute());
                parsedQuery.append(EQ);
                parsedQuery.append(((String)membershipEnume.nextElement()).split(",")[0]);
                parsedQuery.append(CLOSE_PARAN);
            }
            if (!wrapping) continue;
            parsedQuery.append(CLOSE_PARAN);
        }
        return parsedQuery;
    }

    private StringBuffer parseTermQuery(TermQuery q, String attributeType) {
        StringBuffer parsedQuery = new StringBuffer();
        parsedQuery.append(OPEN_PARAN);
        parsedQuery.append(attributeType);
        parsedQuery.append(EQ);
        if (q.isMatchingSubstring() && (q.getMatchingRule().equals("ends_with") || q.getMatchingRule().equals("contains"))) {
            parsedQuery.append(WILDCARD);
        }
        parsedQuery.append(LdapEncoder.filterEncode((String)q.getTerm()));
        if (q.isMatchingSubstring() && (q.getMatchingRule().equals("starts_with") || q.getMatchingRule().equals("contains"))) {
            parsedQuery.append(WILDCARD);
        }
        parsedQuery.append(CLOSE_PARAN);
        return parsedQuery;
    }
}

