/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.ldap.search.page;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.impl.ldap.LDAPEntityFactory;
import com.atlassian.user.impl.ldap.repository.LdapContextFactory;
import com.atlassian.user.impl.ldap.search.LDAPPagerInfo;
import com.atlassian.user.impl.ldap.search.page.AbstractLDAPPager;
import java.util.List;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import org.apache.log4j.Category;

public class LDAPEntityPager
extends AbstractLDAPPager {
    public static final Category log = Category.getInstance(LDAPEntityPager.class);
    protected LDAPEntityFactory entityFactory;

    public LDAPEntityPager(LdapContextFactory repository, LDAPEntityFactory entityFactory, LDAPPagerInfo info) {
        super(repository, info);
        this.entityFactory = entityFactory;
        this.preload();
    }

    @Override
    protected List preloadSearchResult(SearchResult result, List prefetched) throws EntityException {
        try {
            Attributes entityAttributes = result.getAttributes();
            Entity entity = this.entityFactory.getEntity(entityAttributes, result.getName());
            prefetched.add(entity);
        }
        catch (Throwable e) {
            log.error((Object)("There was an error converting the SearchResult: " + result + " into an entity or entities."), e);
        }
        return prefetched;
    }
}

