/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.ldap.properties.factory;

import com.atlassian.user.impl.ldap.properties.DefaultLdapConnectionProperties;
import com.atlassian.user.impl.ldap.properties.LdapConnectionProperties;
import java.util.Properties;
import org.apache.log4j.Logger;

public class LdapConnectionPropertiesFactory {
    protected final Logger log = Logger.getLogger(this.getClass());

    public LdapConnectionProperties createInstance(Properties properties) {
        DefaultLdapConnectionProperties result = new DefaultLdapConnectionProperties();
        result.setHost(properties.getProperty("host", "localhost"));
        result.setJndiInitialContextFactoryIdentifier(properties.getProperty("initialContextFactory"));
        String port = properties.getProperty("port", Integer.toString(389));
        try {
            result.setPort(Integer.parseInt(port));
        }
        catch (NumberFormatException e) {
            this.log.warn((Object)"Error parsing LDAP server port in configuration file, using default value", (Throwable)e);
        }
        String batchSize = properties.getProperty("batchSize", Integer.toString(1000));
        try {
            result.setSearchBatchSize(Integer.parseInt(batchSize));
        }
        catch (NumberFormatException e) {
            this.log.warn((Object)"Error parsing LDAP search batch size in configuration file, using default value", (Throwable)e);
        }
        result.setSecurityAuthentication(properties.getProperty("authentication", "simple"));
        result.setSecurityCredential(properties.getProperty("securityCredential"));
        result.setSecurityPrincipal(properties.getProperty("securityPrincipal"));
        result.setSecurityProtocol(properties.getProperty("securityProtocol"));
        String poolingOn = properties.getProperty("poolingOn", "true");
        result.setPoolingOn(Boolean.valueOf(poolingOn));
        result.setProviderURL(properties.getProperty("providerUrl"));
        return result;
    }
}

