/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.hibernate;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.ExternalEntity;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.impl.DuplicateEntityException;
import com.atlassian.user.impl.RepositoryException;
import com.atlassian.user.impl.hibernate.DefaultHibernateExternalEntity;
import com.atlassian.user.impl.hibernate.DefaultHibernateGroup;
import com.atlassian.user.impl.hibernate.DefaultHibernateUser;
import com.atlassian.user.impl.hibernate.ExternalEntityDAO;
import com.atlassian.user.impl.hibernate.repository.HibernateRepository;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.PagerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.orm.hibernate.HibernateTemplate;
import org.springframework.orm.hibernate.SessionFactoryUtils;
import org.springframework.orm.hibernate.support.HibernateDaoSupport;

public class HibernateGroupManager
extends HibernateDaoSupport
implements GroupManager {
    public static final String GROUPNAME_FIELD = "groupname";
    public static final String GROUPID_FIELD = "groupid";
    public static final String ENTITYID_FIELD = "entityid";
    public static final String EXTERNAL_ENTITY_NAME_FIELD = "externalEntityName";
    private final RepositoryIdentifier identifier;
    protected final HibernateRepository repository;
    protected final UserManager userManager;
    protected final ExternalEntityDAO externalEntityDao;

    public HibernateGroupManager(RepositoryIdentifier identifier, HibernateRepository repository, UserManager userManager, ExternalEntityDAO externalEntityDao) {
        this.identifier = identifier;
        this.repository = repository;
        this.userManager = userManager;
        this.setSessionFactory(repository.getSessionFactory());
        this.externalEntityDao = externalEntityDao;
    }

    @Override
    public Pager getGroups() throws EntityException {
        List result;
        try {
            result = this.getHibernateTemplate().executeFind(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    Query queryObject = session.getNamedQuery("atluser.group_findAll");
                    SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateGroupManager.this.getSessionFactory());
                    return queryObject.list();
                }
            });
        }
        catch (DataAccessException e) {
            throw new RepositoryException(e);
        }
        if (result == null) {
            return new DefaultPager();
        }
        return new DefaultPager(result);
    }

    @Override
    public Pager getGroups(User user) throws EntityException {
        Collection groups = this.getAllGroupsForUser(user);
        return new DefaultPager(groups);
    }

    protected Collection getAllGroupsForUser(User user) throws RepositoryException {
        if (user == null) {
            throw new IllegalArgumentException("Input (user) is null.");
        }
        List groups = this.isUserExternal(user) ? this.getGroupsForExternalEntity(this.getCorrespondingExternalEntity(user)) : this.getGroupsForLocalUser(user);
        return groups;
    }

    protected boolean isUserExternal(User user) {
        return !(user instanceof DefaultHibernateUser);
    }

    protected List getGroupsForLocalUser(User user) throws RepositoryException {
        List result;
        if (user == null) {
            throw new IllegalArgumentException("Input (user) is null.");
        }
        if (this.isUserExternal(user)) {
            return Collections.EMPTY_LIST;
        }
        final DefaultHibernateUser defUser = (DefaultHibernateUser)user;
        try {
            result = this.getHibernateTemplate().executeFind(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    Query queryObject = session.getNamedQuery("atluser.group_getGroupsForUser");
                    SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateGroupManager.this.getSessionFactory());
                    queryObject.setLong(HibernateGroupManager.ENTITYID_FIELD, defUser.getId());
                    return queryObject.list();
                }
            });
        }
        catch (DataAccessException e) {
            throw new RepositoryException(e);
        }
        return result;
    }

    protected List getGroupsForExternalEntity(final ExternalEntity externalEntity) throws RepositoryException {
        List result;
        if (externalEntity == null) {
            throw new IllegalArgumentException("Input (externalEntity) is null.");
        }
        try {
            result = this.getHibernateTemplate().executeFind(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    Query queryObject = session.getNamedQuery("atluser.group_getGroupsForExternalEntity");
                    SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateGroupManager.this.getSessionFactory());
                    if (externalEntity != null) {
                        queryObject.setLong(HibernateGroupManager.ENTITYID_FIELD, externalEntity.getId());
                    }
                    return queryObject.list();
                }
            });
        }
        catch (DataAccessException e) {
            throw new RepositoryException(e);
        }
        return result;
    }

    @Override
    public Pager getMemberNames(Group group) throws EntityException {
        if (group == null) {
            throw new IllegalArgumentException("Group cannot be null.");
        }
        if (!this.isHandledGroup(group)) {
            throw new IllegalArgumentException("Group passed to HibernateGroupManager must be of type 'DefaultHibernateGroup'");
        }
        return PagerFactory.getPager(this.getExternalMemberNames(group), this.getLocalMemberNames(group));
    }

    protected void validateGroup(Group group) {
        if (group == null) {
            throw new IllegalArgumentException("Input (group) is null.");
        }
    }

    @Override
    public Pager getLocalMemberNames(Group group) throws EntityException {
        List result;
        this.validateGroup(group);
        final DefaultHibernateGroup defGroup = (DefaultHibernateGroup)group;
        try {
            result = this.getHibernateTemplate().executeFind(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    Query queryObject = session.getNamedQuery("atluser.group_getLocalMemberNames");
                    SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateGroupManager.this.getSessionFactory());
                    if (defGroup != null) {
                        queryObject.setLong(HibernateGroupManager.GROUPID_FIELD, defGroup.getId());
                    }
                    return queryObject.list();
                }
            });
        }
        catch (DataAccessException e) {
            throw new RepositoryException(e);
        }
        return new DefaultPager(result);
    }

    public Pager getLocalMembers(Group group) throws RepositoryException {
        if (group == null) {
            throw new IllegalArgumentException("Input (group) is null.");
        }
        if (!this.isHandledGroup(group)) {
            return new DefaultPager();
        }
        DefaultHibernateGroup defGroup = (DefaultHibernateGroup)group;
        ArrayList result = new ArrayList(defGroup.getLocalMembers());
        return new DefaultPager(result);
    }

    private boolean isHandledGroup(Group group) {
        return group instanceof DefaultHibernateGroup;
    }

    public Pager getExternalMembers(Group group) throws RepositoryException {
        if (group == null) {
            throw new IllegalArgumentException("Input (group) is null.");
        }
        if (!this.isHandledGroup(group)) {
            return new DefaultPager();
        }
        DefaultHibernateGroup defGroup = (DefaultHibernateGroup)group;
        ArrayList result = new ArrayList(defGroup.getExternalMembers());
        return new DefaultPager(result);
    }

    @Override
    public Pager getExternalMemberNames(Group group) throws EntityException {
        List result;
        if (group == null) {
            throw new IllegalArgumentException("Input (group) is null.");
        }
        if (!this.isHandledGroup(group)) {
            return new DefaultPager();
        }
        final DefaultHibernateGroup defGroup = (DefaultHibernateGroup)group;
        try {
            result = this.getHibernateTemplate().executeFind(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    Query queryObject = session.getNamedQuery("atluser.group_getExternalMemberNames");
                    SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateGroupManager.this.getSessionFactory());
                    if (defGroup != null) {
                        queryObject.setLong(HibernateGroupManager.GROUPID_FIELD, defGroup.getId());
                    }
                    return queryObject.list();
                }
            });
        }
        catch (DataAccessException e) {
            throw new RepositoryException(e);
        }
        return new DefaultPager(result);
    }

    @Override
    public Group getGroup(final String groupname) throws EntityException {
        List result;
        if (groupname == null) {
            throw new IllegalArgumentException("Input (groupname) is null.");
        }
        Group foundGroup = null;
        try {
            result = this.getHibernateTemplate().executeFind(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    Query queryObject = session.getNamedQuery("atluser.group_find");
                    SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateGroupManager.this.getSessionFactory());
                    if (groupname != null) {
                        queryObject.setParameter(HibernateGroupManager.GROUPNAME_FIELD, (Object)groupname);
                    }
                    return queryObject.list();
                }
            });
        }
        catch (DataAccessException e) {
            throw new RepositoryException(e);
        }
        try {
            foundGroup = (Group)result.get(0);
        }
        catch (Exception e) {
            return foundGroup;
        }
        return foundGroup;
    }

    @Override
    public Group createGroup(String groupname) throws EntityException {
        if (groupname == null) {
            throw new IllegalArgumentException("Input (groupname) is null.");
        }
        Group group = this.getGroup(groupname);
        if (group != null) {
            throw new DuplicateEntityException("Group [" + groupname + "] already exists in this repository (" + this.identifier.getName() + ")");
        }
        group = new DefaultHibernateGroup(groupname);
        this.getHibernateTemplate().save((Object)group);
        return group;
    }

    @Override
    public void removeGroup(Group group) throws EntityException {
        Group groupInSession = this.getGroupInSession(group);
        DefaultHibernateGroup dGroup = (DefaultHibernateGroup)groupInSession;
        dGroup.setExternalMembers(null);
        dGroup.setLocalMembers(null);
        this.getHibernateTemplate().delete((Object)groupInSession);
    }

    @Override
    public void addMembership(Group group, User user) throws EntityException {
        this.validateGroupAndUser(group, user);
        Group groupInSession = this.getGroupInSession(group);
        DefaultHibernateGroup dGroup = (DefaultHibernateGroup)groupInSession;
        if (this.isUserExternal(user)) {
            HashSet<ExternalEntity> membership = dGroup.getExternalMembers();
            if (membership == null) {
                membership = new HashSet<ExternalEntity>();
                dGroup.setExternalMembers(membership);
            }
            ExternalEntity member = this.getCorrespondingExternalEntity(user);
            membership.add(member);
        } else {
            HashSet<User> membership = dGroup.getLocalMembers();
            if (membership == null) {
                membership = new HashSet<User>();
                dGroup.setLocalMembers(membership);
            }
            membership.add(user);
        }
        try {
            this.getHibernateTemplate().saveOrUpdate((Object)dGroup);
            this.getSession().flush();
        }
        catch (HibernateException e) {
            throw new EntityException(e);
        }
    }

    protected ExternalEntity getCorrespondingExternalEntity(User user) throws RepositoryException {
        if (user == null) {
            throw new IllegalArgumentException("Input (user) is null.");
        }
        ExternalEntity result = this.externalEntityDao.getExternalEntity(user.getName());
        if (result == null) {
            return this.createExternalEntity(user);
        }
        return result;
    }

    protected ExternalEntity createExternalEntity(User user) {
        DefaultHibernateExternalEntity entity = new DefaultHibernateExternalEntity();
        entity.setName(user.getName());
        entity.setType(user.getClass().getName());
        this.externalEntityDao.saveExternalEntity(entity);
        return entity;
    }

    @Override
    public boolean hasMembership(Group group, User user) throws EntityException {
        if (group == null || this.getGroup(group.getName()) == null) {
            return false;
        }
        this.validateGroupAndUser(group, user);
        DefaultHibernateGroup defGroup = (DefaultHibernateGroup)this.getGroupInSession(group);
        if (this.isUserExternal(user)) {
            return this.hasExternalMembership(defGroup, user);
        }
        return this.hasLocalMembership(defGroup, (DefaultHibernateUser)user);
    }

    protected void validateGroupAndUser(Group group, User user) throws EntityException {
        if (group == null) {
            throw new IllegalArgumentException("Can't add membership for null group");
        }
        if (this.getGroup(group.getName()) == null) {
            throw new IllegalArgumentException("Group unknown: [" + group + "] in [" + this.identifier.getKey() + "]");
        }
        if (user == null) {
            throw new IllegalArgumentException("User unknown: [" + user + "] in [" + this.identifier.getKey() + "]");
        }
        if (!this.isHandledGroup(group)) {
            throw new IllegalArgumentException("Group is not a Hibernate entity [" + group.getClass().getName());
        }
    }

    protected boolean hasExternalMembership(DefaultHibernateGroup defGroup, User user) throws EntityException {
        ExternalEntity entity = this.getCorrespondingExternalEntity(user);
        return defGroup.getExternalMembers().contains(entity);
    }

    protected boolean hasLocalMembership(DefaultHibernateGroup defGroup, DefaultHibernateUser defUser) throws EntityException {
        Collection usersGroups = this.getAllGroupsForUser(defUser);
        return usersGroups != null && usersGroups.contains(defGroup);
    }

    @Override
    public void removeMembership(Group group, User user) throws EntityException {
        this.validateGroupAndUser(group, user);
        Group groupInSession = this.getGroupInSession(group);
        DefaultHibernateGroup hibernateGroup = (DefaultHibernateGroup)groupInSession;
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        if (this.isUserExternal(user)) {
            ExternalEntity extUser = this.getCorrespondingExternalEntity(user);
            hibernateGroup.getExternalMembers().remove(extUser);
        } else {
            hibernateGroup.getLocalMembers().remove(user);
        }
        hibernateTemplate.saveOrUpdate((Object)groupInSession);
        hibernateTemplate.flush();
    }

    @Override
    public boolean isReadOnly(Group group) throws EntityException {
        return this.getGroup(group.getName()) == null;
    }

    @Override
    public boolean supportsExternalMembership() throws EntityException {
        return false;
    }

    @Override
    public RepositoryIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public RepositoryIdentifier getRepository(Entity entity) throws EntityException {
        if (this.getGroup(entity.getName()) != null) {
            return this.identifier;
        }
        return null;
    }

    @Override
    public boolean isCreative() {
        return true;
    }

    private Group getGroupInSession(Group group) throws EntityException {
        if (group == null) {
            throw new IllegalArgumentException("Input (group) is null.");
        }
        if (!this.isHandledGroup(group)) {
            throw new IllegalArgumentException("Group is not a Hibernate entity [" + group.getClass().getName());
        }
        return this.getGroup(group.getName());
    }
}

