/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.delegation;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.impl.DuplicateEntityException;
import com.atlassian.user.impl.delegation.repository.DelegatingRepository;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.PagerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DelegatingListUserManager
implements UserManager {
    private final List userManagers;

    public DelegatingListUserManager(List userManagers) {
        this.userManagers = userManagers;
    }

    @Override
    public Pager getUsers() throws EntityException {
        ArrayList<Pager> pagers = new ArrayList<Pager>();
        for (UserManager userManager : this.userManagers) {
            pagers.add(userManager.getUsers());
        }
        return PagerFactory.getPager(pagers);
    }

    @Override
    public Pager getUserNames() throws EntityException {
        ArrayList<Pager> pagers = new ArrayList<Pager>();
        for (UserManager userManager : this.userManagers) {
            pagers.add(userManager.getUserNames());
        }
        return PagerFactory.getPager(pagers);
    }

    @Override
    public User getUser(String username) throws EntityException {
        UserManager userManager;
        User foundUser = null;
        Iterator userManagersIter = this.userManagers.iterator();
        while (userManagersIter.hasNext() && (foundUser = (userManager = (UserManager)userManagersIter.next()).getUser(username)) == null) {
        }
        return foundUser;
    }

    @Override
    public User createUser(String username) throws EntityException {
        User preexistingUser;
        try {
            preexistingUser = this.getUser(username);
        }
        catch (EntityException e) {
            throw new EntityException("Couldn't check whether user already exists", e);
        }
        if (preexistingUser != null) {
            throw new DuplicateEntityException("User [" + username + "] already exists in " + this.getRepository(preexistingUser).getName());
        }
        User createdUser = null;
        for (UserManager userManager : this.userManagers) {
            if (userManager.isCreative()) {
                createdUser = userManager.createUser(username);
            }
            if (createdUser == null) continue;
            break;
        }
        if (createdUser == null) {
            throw new EntityException("Could not create user: " + username + ". " + "Ensure you have a read-write repository configured.");
        }
        return createdUser;
    }

    @Override
    public void alterPassword(User user, String plainTextPass) throws EntityException {
        UserManager userManager = this.getMatchingUserManager(user);
        if (userManager == null) {
            throw new EntityException("Cannot find a userManager responsible for user [" + user.getName() + "]");
        }
        userManager.alterPassword(user, plainTextPass);
    }

    @Override
    public void saveUser(User user) throws EntityException {
        UserManager userManager = this.getMatchingUserManager(user);
        if (userManager == null) {
            throw new EntityException("Cannot find a userManager responsible for user [" + user.getName() + "]");
        }
        userManager.saveUser(user);
    }

    @Override
    public void removeUser(User user) throws EntityException {
        UserManager userManager = this.getMatchingUserManager(user);
        if (userManager == null) {
            throw new IllegalArgumentException("Cannot find a userManager responsible for user [" + user.getName() + "]");
        }
        userManager.removeUser(user);
    }

    @Override
    public boolean isReadOnly(User user) throws EntityException {
        UserManager userManager = this.getMatchingUserManager(user);
        if (userManager != null) {
            return userManager.isReadOnly(user);
        }
        throw new EntityException("Cannot find a userManager responsible for user [" + user.getName() + "]");
    }

    @Override
    public RepositoryIdentifier getIdentifier() {
        Iterator iter = this.userManagers.iterator();
        ArrayList<RepositoryIdentifier> repositories = new ArrayList<RepositoryIdentifier>();
        while (iter.hasNext()) {
            UserManager userManager = (UserManager)iter.next();
            repositories.add(userManager.getIdentifier());
        }
        return new DelegatingRepository(repositories);
    }

    @Override
    public RepositoryIdentifier getRepository(Entity entity) throws EntityException {
        for (UserManager userManager : this.userManagers) {
            RepositoryIdentifier repo = userManager.getRepository(entity);
            if (repo == null) continue;
            return repo;
        }
        return null;
    }

    @Override
    public boolean isCreative() {
        for (UserManager userManager : this.userManagers) {
            if (!userManager.isCreative()) continue;
            return true;
        }
        return false;
    }

    protected UserManager getMatchingUserManager(User user) throws EntityException {
        for (UserManager matchingUserManager : this.userManagers) {
            User foundUser = matchingUserManager.getUser(user.getName());
            if (foundUser == null) continue;
            return matchingUserManager;
        }
        return null;
    }

    public List getUserManagers() {
        return Collections.unmodifiableList(this.userManagers);
    }
}

