/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.cache;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.impl.DefaultUser;
import com.atlassian.user.impl.cache.Cache;
import com.atlassian.user.impl.cache.CacheManager;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.page.Pager;

public class CachingUserManager
implements UserManager {
    private final UserManager underlyingUserManager;
    private final CacheManager cacheManager;
    private String userCacheName = null;
    private String userROCacheName = null;
    private String repositoryCacheName = null;
    private static final String CACHE_SUFFIX_USERS = "users";
    private static final String CACHE_SUFFIX_USERS_RO = "users_ro";
    private static final String CACHE_SUFFIX_REPOSITORIES = "repository";
    protected static User NULL_USER = new DefaultUser(){

        @Override
        public String toString() {
            return "NULL USER";
        }
    };

    public CachingUserManager(UserManager underlyingUserManager, CacheManager cacheManager) {
        this.underlyingUserManager = underlyingUserManager;
        this.cacheManager = cacheManager;
    }

    @Override
    public Pager getUsers() throws EntityException {
        return this.underlyingUserManager.getUsers();
    }

    @Override
    public Pager getUserNames() throws EntityException {
        return this.underlyingUserManager.getUserNames();
    }

    @Override
    public User getUser(String username) throws EntityException {
        User cachedUser = (User)this.getUserCache().get(username);
        if (cachedUser != null) {
            return NULL_USER.equals(cachedUser) ? null : cachedUser;
        }
        User user = this.underlyingUserManager.getUser(username);
        this.cacheUser(username, user);
        return user;
    }

    private void cacheUser(String username, User user) {
        this.getUserCache().put(username, user == null ? NULL_USER : user);
    }

    private void cacheRepository(String username, RepositoryIdentifier repository) {
        this.getRepositoryCache().put(username, repository);
    }

    private void cacheUserROFlag(User user, boolean ro) {
        this.getUserROFlagCache().put(user.getName(), ro);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache getUserCache() {
        CachingUserManager cachingUserManager = this;
        synchronized (cachingUserManager) {
            if (this.userCacheName == null) {
                this.userCacheName = this.getCacheKey(CACHE_SUFFIX_USERS);
            }
        }
        return this.cacheManager.getCache(this.userCacheName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache getUserROFlagCache() {
        CachingUserManager cachingUserManager = this;
        synchronized (cachingUserManager) {
            if (this.userROCacheName == null) {
                this.userROCacheName = this.getCacheKey(CACHE_SUFFIX_USERS_RO);
            }
        }
        return this.cacheManager.getCache(this.userROCacheName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache getRepositoryCache() {
        CachingUserManager cachingUserManager = this;
        synchronized (cachingUserManager) {
            if (this.repositoryCacheName == null) {
                this.repositoryCacheName = this.getCacheKey(CACHE_SUFFIX_REPOSITORIES);
            }
        }
        return this.cacheManager.getCache(this.repositoryCacheName);
    }

    @Override
    public User createUser(String username) throws EntityException {
        User user = this.underlyingUserManager.createUser(username);
        if (user != null) {
            this.cacheUser(user.getName(), user);
        }
        return user;
    }

    @Override
    public void alterPassword(User user, String plainTextPass) throws EntityException {
        this.underlyingUserManager.alterPassword(user, plainTextPass);
    }

    @Override
    public void saveUser(User user) throws EntityException {
        this.underlyingUserManager.saveUser(user);
        if (user != null) {
            this.cacheUser(user.getName(), user);
        }
    }

    @Override
    public void removeUser(User user) throws EntityException {
        this.underlyingUserManager.removeUser(user);
        try {
            this.removeUserFromCache(user);
        }
        catch (Exception e) {
            throw new EntityException("User removed in underlying repository but could not remove from cache");
        }
    }

    private void removeUserFromCache(User user) throws Exception {
        this.getUserCache().remove(user.getName());
    }

    @Override
    public boolean isReadOnly(User user) throws EntityException {
        Boolean cachedROFlag = (Boolean)this.getUserROFlagCache().get(user.getName());
        if (cachedROFlag == null) {
            boolean ro = this.underlyingUserManager.isReadOnly(user);
            this.cacheUserROFlag(user, ro);
            return ro;
        }
        return cachedROFlag;
    }

    @Override
    public RepositoryIdentifier getIdentifier() {
        return this.underlyingUserManager.getIdentifier();
    }

    @Override
    public RepositoryIdentifier getRepository(Entity entity) throws EntityException {
        RepositoryIdentifier cachedRepository = (RepositoryIdentifier)this.getRepositoryCache().get(entity.getName());
        if (cachedRepository != null) {
            return cachedRepository;
        }
        RepositoryIdentifier repository = this.underlyingUserManager.getRepository(entity);
        this.cacheRepository(entity.getName(), repository);
        return repository;
    }

    @Override
    public boolean isCreative() {
        return this.underlyingUserManager.isCreative();
    }

    private String getCacheKey(String cacheName) {
        String className = this.underlyingUserManager.getClass().getName();
        String repositoryKey = this.underlyingUserManager.getIdentifier().getKey();
        return className + "." + repositoryKey + "." + cacheName;
    }
}

