/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.as.security.authentication;

import com.atlassian.security.password.DefaultPasswordEncoder;
import com.atlassian.security.password.PasswordEncoder;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.impl.DefaultUser;
import com.atlassian.user.impl.osuser.security.password.OSUPasswordEncryptor;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.security.authentication.Authenticator;
import com.atlassian.user.security.authentication.EntityAuthenticationException;
import com.atlassian.user.security.password.PasswordEncryptor;
import org.apache.log4j.Logger;

public class AtlassianSecurityAuthenticator
implements Authenticator {
    private static final Logger log = Logger.getLogger(AtlassianSecurityAuthenticator.class);
    private static final PasswordEncoder PASSWORD_ENCODER = DefaultPasswordEncoder.getDefaultInstance();
    private final UserManager userManager;
    private final PasswordEncryptor legacyEncryptor;

    public AtlassianSecurityAuthenticator(UserManager userManager) {
        this.userManager = userManager;
        this.legacyEncryptor = new OSUPasswordEncryptor();
    }

    @Override
    public boolean authenticate(String username, String password) throws EntityException {
        User user = this.userManager.getUser(username);
        if (user instanceof DefaultUser) {
            DefaultUser defaultUser = (DefaultUser)user;
            try {
                String encodedPassword = defaultUser.getPassword();
                if (encodedPassword != null) {
                    if (PASSWORD_ENCODER.canDecodePassword(encodedPassword)) {
                        return PASSWORD_ENCODER.isValidPassword(password, encodedPassword);
                    }
                    boolean isValid = encodedPassword.equals(this.legacyEncryptor.encrypt(password));
                    if (isValid) {
                        this.userManager.alterPassword(defaultUser, password);
                    }
                    return isValid;
                }
            }
            catch (Exception e) {
                throw new EntityAuthenticationException(e);
            }
        }
        return false;
    }

    @Override
    public RepositoryIdentifier getRepository() {
        return this.userManager.getIdentifier();
    }
}

