/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.configuration.xml;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Element;

final class XMLConfigUtil {
    private XMLConfigUtil() {
    }

    public static HashMap parseRepositoryElementForClassNames(Element repositoryElement) {
        HashMap<String, String> values = new HashMap<String, String>();
        Element classesElement = repositoryElement.element("classes");
        if (classesElement == null) {
            return values;
        }
        List subElements = classesElement.elements();
        for (Element element : subElements) {
            if (element.getName().equals("param")) {
                Attribute paramAttribute = element.attribute("name");
                values.put(paramAttribute.getText(), element.getText());
                continue;
            }
            values.put(element.getName(), element.getText());
        }
        Attribute attr = repositoryElement.attribute("class");
        if (attr != null) {
            values.put("class", attr.getText());
        }
        return values;
    }

    public static Map parseRepositoryElementForStringData(Element repositoryElement) {
        HashMap<String, String> values = new HashMap<String, String>();
        for (Attribute attr : repositoryElement.attributes()) {
            if (attr.getName().equals("class")) continue;
            values.put(attr.getName(), attr.getText());
        }
        for (Element element : repositoryElement.elements()) {
            if (element.getName().equals("classes")) continue;
            values.put(element.getName(), element.getText());
        }
        return values;
    }
}

