package com.atlassian.user.util.migration;

import com.atlassian.user.User;
import com.atlassian.user.impl.DefaultUser;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

import javax.sql.DataSource;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class OSUserDao extends JdbcDaoSupport
{
    private static final String USERNAME_COL = "username";
    private static final String ID_COL = "id";
    private static final String PASSWORD_COL = "passwd";
    private static final String KEY_COL = "entity_key";
    private static final String VALUE_COL = "string_val";

    private static final String OSUSER_TABLE = "os_user";
    private static final String OSPROPERTYSET_TABLE = "OS_PROPERTYENTRY";

    OSUserDao(DataSource dataSource)
    {
        setDataSource(dataSource);
    }

    /**
     * Gets all users populated with their 'basic' properties from the OSUSER_TABLE and the OSPROPERTYSET_TABLE
     *
     * @return a collection of {@link com.atlassian.user.impl.DefaultUser}
     */
    Map findAllUsers()
    {
        final Map users = new HashMap();

        // get username and password from OSUSER_TABLE
        getJdbcTemplate().query("select * from " + OSUSER_TABLE, new RowCallbackHandler()
        {
            public void processRow(ResultSet rs) throws SQLException
            {
                final Long id = new Long(rs.getLong(ID_COL));

                final DefaultUser user = new DefaultUser(rs.getString(USERNAME_COL));
                user.setPassword(rs.getString(PASSWORD_COL));

                users.put(id, user);
            }
        });

        // get fullname and email from OSPROPERTYSET_TABLE
        getJdbcTemplate().query("SELECT * FROM " + OSPROPERTYSET_TABLE + " WHERE entity_name='OSUser_user' " +
            "AND ( entity_key='fullName' OR entity_key='email')", new RowCallbackHandler()
        {
            public void processRow(ResultSet resultSet) throws SQLException
            {
                final Long id = new Long(resultSet.getLong("entity_id"));
                final User user = (User) users.get(id);
                if (user != null)
                {
                    final String key = resultSet.getString(KEY_COL);
                    final String value = resultSet.getString(VALUE_COL);
                    if ("fullName".equals(key))
                    {
                        user.setFullName(value);
                    }
                    else if ("email".equals(key))
                    {
                        user.setEmail(value);
                    }
                }
            }
        });

        return users;
    }
}
