package com.atlassian.user.util.migration;

import org.apache.log4j.Logger;

/**
 *
 */
public class Log4jMigrationProgressListener implements MigrationProgressListener
{
    private final Logger logger;

    private int usersToMigrate;

    private int usersMigrated = 0;

    private int groupsToMigrate;

    private int groupsMigrated = 0;

    public Log4jMigrationProgressListener(final Logger logger)
    {
        if (logger == null)
            throw new IllegalArgumentException("Log4j logger must NOT be null");
        this.logger = logger;
    }

    public void userMigrationStarted(int usersToMigrate)
    {
        this.usersToMigrate = usersToMigrate;
        logger.info("Starting user migration. " + usersToMigrate + " users to migrate.");
    }

    public void userMigrated()
    {
        if (++usersMigrated % 100 == 0)
        {
            logger.info(usersMigrated + " users migrated out of " + usersToMigrate + ".");
        }
    }

    public void userMigrationComplete()
    {
        logger.info("User migration complete.");
    }

    public void groupMigrationStarted(int groupsToMigrate)
    {
        this.groupsToMigrate = groupsToMigrate;
        logger.info("Group migration started. " + groupsToMigrate + " groups to migrate.");
    }

    public void groupMigrated()
    {
        if (++groupsMigrated % 100 == 0)
        {
            logger.info(groupsMigrated + " groups migrated out of " + groupsToMigrate + ".");
        }
    }

    public void groupMigrationComplete()
    {
        logger.info("Group migration complete.");
    }
}
