package com.atlassian.user.search.query;

public interface TermQuery extends Query
{
    final String SUBSTRING_STARTS_WITH = "starts_with";
    final String SUBSTRING_ENDS_WITH = "ends_with";
    final String SUBSTRING_CONTAINS = "contains";
    final String WILDCARD = "*";
    
    /**
     * @return a String holding the system indepdent value of the term to match for equality.
     *
     * For example, in a ColourQuery this term might be 'red' but, when rendered, would be
     * represented as "select colour from colour_table where colour = 'red'"
     */
    String getTerm();

    String getMatchingRule();

    boolean isMatchingSubstring();

}
