package com.atlassian.user.search.query;

import com.atlassian.user.EntityException;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.SearchResult;

/**
 * Implementations can currently only support one boolean condition
 */
public interface EntityQueryParser
{
    /**
     * Generates a {@link SearchResult} object holding results for each {@link RepositoryIdentifier} the
     * the entityQueryParser can access..
     */
    SearchResult findUsers(Query query) throws EntityException;

    /**
     * Generates a {@link SearchResult} object holding results for each {@link RepositoryIdentifier} the
     * the entityQueryParser can access..
     */
    SearchResult findGroups(Query query) throws EntityException;

    /**
     * Generates a {@link SearchResult} object holding results for each {@link RepositoryIdentifier} the
     * entityQueryParser has been instructed, via a {@link QueryContext} to search.
     *
     * @return returns the search result or null if this entity query parser is out of scope of the context
     */
    SearchResult findUsers(Query query, QueryContext context) throws EntityException;

    /**
     * Generates a {@link SearchResult} object holding results for each {@link RepositoryIdentifier} the
     * entityQueryParser has been instructed, via a {@link QueryContext} to search.
     */
    SearchResult findGroups(Query query, QueryContext context) throws EntityException;
}
