package com.atlassian.user.search.query;

import java.util.ArrayList;
import java.util.List;

public class DefaultQueryContext implements QueryContext
{
    private ArrayList repositoryKeys;

    public DefaultQueryContext()
    {
        this.repositoryKeys = new ArrayList();
    }

    public void addRepositoryKey(String key) throws IllegalArgumentException
    {
        if (repositoryKeys.contains(key) || repositoryKeys.contains(QueryContext.ALL_REPOSITORIES))
            throw new IllegalArgumentException("Repository key [" + key + " is already listed in this query context.");

        repositoryKeys.add(key);
    }

    public List getRepositoryKeys()
    {
        return repositoryKeys;
    }
}
