package com.atlassian.user.search.page;

import java.util.*;

public class DefaultPager implements Pager
{
    private final List page = new ArrayList();
    private Iterator iter;
    private int index;

    public DefaultPager()
    {
        this(Collections.EMPTY_LIST);
    }

    public DefaultPager(Collection col)
    {
        if (col != null)
        {
            page.addAll(col);
        }

        iter = page.iterator();
    }

    public boolean isEmpty()
    {
        if (page == null) return true;

        return page.isEmpty();
    }

    public Iterator iterator()
    {
        return iter;
    }

    /**
     * @return a single, preloaded page.
     */
    public List getCurrentPage()
    {
        return new ArrayList(page);
    }

    public void nextPage()
    {
        //do nothing, all contents are already within the currentPage
    }

    public boolean onLastPage()
    {
        return true;
    }

    public void skipTo(int index) throws PagerException
    {
        if (index < 0)
            throw new PagerException("Cannot skipTo a negative amount [" + index + "]");

        int originalIndex = this.index;
        int distance;

        if (index > page.size())
        {
            distance = page.size();
            this.index = page.size();
        }
        else
        {
            distance = index - this.index;
            this.index = index;
        }

        for (int i = originalIndex; i < distance; i++)
            iter.next();
    }

    /**
     * @return the current index position of the pager
     */
    public int getIndex()
    {
        return index;
    }

    /**
     *  This pager always has all its items in a single page
     * @return zero, because this pager has all its items in a single page
     */
    public int getIndexOfFirstItemInCurrentPage()
    {
        return 0;
    }

    public void remove()
    {
        throw new UnsupportedOperationException("This iterator does not support removal");
    }

    public boolean hasNext()
    {
        return iter.hasNext();
    }

    public Object next()
    {
        Object o = iter.next();
        index++;

        return o;
    }
}
