package com.atlassian.user.search.page;

import com.atlassian.user.EntityException;
import org.apache.log4j.Category;

import java.util.*;

public abstract class AbstractPrefetchingPager implements Pager, Iterator
{
    public static final Category log = Category.getInstance(AbstractPrefetchingPager.class);
    protected int idx = 0;
    private final int preloadLimit = PRELOAD_LIMIT;
    private final List prefetched = new ArrayList(preloadLimit);
    protected int indexOfFirstItemInCurrentPage = 0;
    public boolean lastPage;

    public Iterator iterator()
    {
        return this;
    }

    public boolean isEmpty()
    {
        return !hasNext();
    }

    public List getCurrentPage()
    {
        return new ArrayList(prefetched);
    }

    public boolean hasNext()
    {
       int indexWithinPage = getIndexWithinPage();
       if (indexWithinPage == prefetched.size() && !lastPage)
       {
            preload();
            indexWithinPage = getIndexWithinPage();
       }
       return indexWithinPage < prefetched.size() || !lastPage;
    }

    protected abstract void preload();

    public void remove()
    {
        throw new UnsupportedOperationException();
    }

    protected void preload(Iterator iterator)
    {
        prefetched.clear();
        int currentPos = 0;

        try
        {
            while (!lastPage && prefetched.size() < preloadLimit)
            {
                if (!iterator.hasNext())
                {
                    lastPage = true;
                    break;
                }

                Object element = iterator.next();

                List entities = new ArrayList();
                fetch(element, entities);

                for (Iterator i = entities.iterator(); i.hasNext() && prefetched.size() < preloadLimit;)
                {
                    Object r = i.next();
                    if (currentPos >= idx)
                    {
                        prefetched.add(r);
                    }
                    ++currentPos;
                }
            }
            if (prefetched.size() < preloadLimit)
            {
                lastPage = true;
            }
        }
        catch (Exception e)
        {
            log.error("At index [" + idx + "]: " + e.getMessage(), e);
            lastPage = true;
        }
    }

    abstract protected List fetch(Object element, List prefetched) throws EntityException;

    public void nextPage()
    {
        idx += PRELOAD_LIMIT;
        preload();
    }

    public int getIndex()
    {
        return idx;
    }

    public void skipTo(int idx) throws PagerException
    {
        this.idx = idx;
        preload();

        if (prefetched == null || prefetched.size() == 0)
        {
            this.idx = NO_POSITION;
        }
    }

    public boolean onLastPage()
    {
        return lastPage;
    }

    public int getIndexOfFirstItemInCurrentPage()
    {
        return indexOfFirstItemInCurrentPage;
    }

    public Object next()
    {
        if (!hasNext())
            throw new NoSuchElementException();
        int indexWithinPage = getIndexWithinPage();
        Object nextObj = prefetched.get(indexWithinPage);
        idx++;

        return nextObj;
    }

    protected int getIndexWithinPage()
    {
        return idx - indexOfFirstItemInCurrentPage;
    }
}
