package com.atlassian.user.impl.memory.provider;

import com.atlassian.user.User;
import com.atlassian.user.Group;
import com.atlassian.user.EntityException;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.PagerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class MemoryProvider
{
    private HashMap users;
    private HashMap groups;
    private List localMembership;
    private List externalMembership;

    class Membership
    {
        Group group;
        User user;

        public Membership(Group group, User user)
        {
            this.group = group;
            this.user = user;
        }

        public Group getGroup()
        {
            return group;
        }

        public User getUser()
        {
            return user;
        }

        public boolean equals(Object o)
        {
            if (this == o) return true;
            if (!(o instanceof Membership)) return false;

            final Membership membership = (Membership) o;

            if (group != null ? !group.equals(membership.group) : membership.group != null) return false;
            if (user != null ? !user.equals(membership.user) : membership.user != null) return false;

            return true;
        }

        public int hashCode()
        {
            int result;
            result = (group != null ? group.hashCode() : 0);
            result = 29 * result + (user != null ? user.hashCode() : 0);
            return result;
        }
    }

    public MemoryProvider()
    {
        users = new HashMap();
        groups = new HashMap();
        localMembership = new ArrayList();
        externalMembership = new ArrayList();
    }

    public Pager getUserNames()
    {
        List usernames = new ArrayList();

        Iterator userIter = users.values().iterator();

        while (userIter.hasNext())
        {
            User user = (User) userIter.next();
            usernames.add(user.getName());
        }

        return new DefaultPager(usernames);
    }

    public Pager getUsers()
    {
        return new DefaultPager(new ArrayList(users.values()));
    }

    public User getUser(String username)
    {
        return (User) users.get(username);
    }

    public Pager getGroups()
    {
        return new DefaultPager(new ArrayList(groups.values()));
    }

    public Pager getGroups(User user)
    {
        ArrayList groupList = new ArrayList();

        for (int i = 0; i < localMembership.size(); i++)
        {
            Membership membership1 = (Membership) localMembership.get(i);
            if (membership1.getUser().equals(user))
                groupList.add(membership1.getGroup());
        }
        return new DefaultPager(groupList);
    }

    public void addGroup(Group group) throws EntityException
    {
        groups.put(group.getName(), group);
    }

    public void removeGroup(Group group) throws EntityException, IllegalArgumentException
    {
        if (group == null || getGroup(group.getName()) == null)
        {
            throw new IllegalArgumentException("Group is null or doesn't exist in repository");
        }

        groups.remove(group.getName());
        for (Iterator iter = localMembership.iterator(); iter.hasNext();)
        {
            Membership membership = (Membership) iter.next();
            if (membership.getGroup().equals(group))
                iter.remove();
        }
        for (Iterator iter = externalMembership.iterator(); iter.hasNext();)
        {
            Membership membership = (Membership) iter.next();
            if (membership.getGroup().equals(group))
                iter.remove();
        }
    }

    public Group getGroup(String groupName)
    {
        return (Group) groups.get(groupName);
    }

    public void addUser(User user)
    {
        users.put(user.getName(), user);
    }

    public void removeUser(User user) throws EntityException
    {
        users.remove(user.getName());

        for (int i = 0; i < localMembership.size(); i++)
        {
            Membership membership1 = (Membership) localMembership.get(i);

            if (membership1.getUser().equals(user))
            {
                localMembership.remove(membership1);
                if (localMembership.size() > 0 && i != localMembership.size())
                    i--;
            }
        }

        for (int i = 0; i < externalMembership.size(); i++)
        {
            Membership membership1 = (Membership) externalMembership.get(i);

            if (membership1.getUser().equals(user))
            {
                externalMembership.remove(membership1);
                if (externalMembership.size() > 0 && i != externalMembership.size())
                    i--;
            }
        }

    }


    /**
     * This might have been done at a higher level but it will generally be done at the provider level,
     * for non-memory implementations. It's good practice to situate it here, in the prototype.
     */
    public void addMembership(Group group, User user)
    {
        if (group == null)
            throw new IllegalArgumentException("Cannot add membership for user [" + user + "] to a null group.");

        if (user == null)
            throw new IllegalArgumentException("Cannot add membership for null user to group [" + group + "]");

        Membership membership1 = new Membership(group, user);

        List check;
        if (isUserLocal(user))
            check = localMembership;
        else
            check = externalMembership;

        for (int i = 0; i < check.size(); i++)
        {
            Membership membership2 = (Membership) check.get(i);

            if (membership2.equals(membership1))
                return;
        }

        check.add(membership1);
    }

    boolean isUserLocal(User user)
    {
        return (users.get(user.getName()) != null);
    }

    public void removeMembership(Group group, User user)
    {
        List check;
        if (isUserLocal(user))
            check = localMembership;
        else
            check = externalMembership;

        for (int i = 0; i < check.size(); i++)
        {
            Membership membership1 = (Membership) check.get(i);
            if (membership1.getUser().equals(user) && membership1.getGroup().equals(group))
                check.remove(membership1);
        }
    }

    public Pager getMemberNames(Group group)
    {
        return PagerFactory.getPager(getLocalMembersNames(group), getExternalMembersNames(group));
    }

    public Pager getExternalMembersNames(Group group)
    {
        ArrayList members = new ArrayList();

        for (int i = 0; i < externalMembership.size(); i++)
        {
            Membership membership1 = (Membership) externalMembership.get(i);
            if (membership1.getGroup().equals(group))
                members.add(membership1.getUser().getName());
        }

        return new DefaultPager(members);
    }


    public Pager getExternalMemberNames(Group group)
    {
        ArrayList members = new ArrayList();

        for (int i = 0; i < externalMembership.size(); i++)
        {
            Membership membership1 = (Membership) externalMembership.get(i);
            if (membership1.getGroup().equals(group))
                members.add(membership1.getUser().getName());
        }

        return new DefaultPager(members);
    }

    public Pager getExternalMembers(Group group)
    {
        ArrayList members = new ArrayList();

        for (int i = 0; i < externalMembership.size(); i++)
        {
            Membership membership1 = (Membership) externalMembership.get(i);
            if (membership1.getGroup().equals(group))
                members.add(membership1.getUser());
        }

        return new DefaultPager(members);
    }

    public Pager getLocalMembersNames(Group group)
    {
        ArrayList members = new ArrayList();

        for (int i = 0; i < localMembership.size(); i++)
        {
            Membership membership1 = (Membership) localMembership.get(i);
            if (membership1.getGroup().equals(group))
                members.add(membership1.getUser().getName());
        }

        return new DefaultPager(members);
    }

    public Pager getLocalMemberNames(Group group)
    {
        ArrayList members = new ArrayList();

        for (int i = 0; i < localMembership.size(); i++)
        {
            Membership membership1 = (Membership) localMembership.get(i);
            if (membership1.getGroup().equals(group))
                members.add(membership1.getUser().getName());
        }

        return new DefaultPager(members);
    }

    public Pager getLocalMembers(Group group)
    {
        ArrayList members = new ArrayList();

        for (int i = 0; i < localMembership.size(); i++)
        {
            Membership membership1 = (Membership) localMembership.get(i);
            if (membership1.getGroup().equals(group))
                members.add(membership1.getUser());
        }

        return new DefaultPager(members);
    }

    public boolean hasMembership(Group group, User user)
    {
        if (isUserLocal(user))
        {
            for (int i = 0; i < localMembership.size(); i++)
            {
                Membership membership1 = (Membership) localMembership.get(i);

                if (membership1.getGroup().equals(group) && membership1.getUser().equals(user))
                    return true;
            }
        }
        else
        {
            for (int i = 0; i < externalMembership.size(); i++)
            {
                Membership membership1 = (Membership) externalMembership.get(i);

                if (membership1.getGroup().equals(group) && membership1.getUser().equals(user))
                    return true;
            }
        }

        return false;
    }
}