package com.atlassian.user.impl.ldap.search.page;

import com.atlassian.user.EntityException;
import com.atlassian.user.impl.ldap.repository.LdapContextFactory;
import com.atlassian.user.impl.ldap.search.LDAPPagerInfo;
import org.apache.log4j.Category;

import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import java.util.List;

public class LDAPSingleStringPager extends AbstractLDAPPager
{
    public static final Category log = Category.getInstance(LDAPSingleStringPager.class);

    public LDAPSingleStringPager(LdapContextFactory repository, LDAPPagerInfo info)
    {
        super(repository, info);

        preload();
    }

    protected List preloadSearchResult(SearchResult result, List prefetched) throws EntityException
    {
        try
        {
            Attributes entityAttributes = result.getAttributes();
            String attributeToFind = returningAttributes[0];
            Attribute attr = entityAttributes.get(attributeToFind);
            prefetched.add(attr.get());
        }
        catch (Throwable t)
        {
            log.error("Error converting search result: " + result + " into a string value.", t);
        }

        return prefetched;
    }
}
