package com.atlassian.user.impl.ldap.search.page;

import com.atlassian.user.EntityException;
import com.atlassian.user.impl.ldap.repository.LdapContextFactory;
import com.atlassian.user.impl.ldap.search.LDAPPagerInfo;
import com.atlassian.user.search.page.PagerUtils;
import org.apache.log4j.Category;

import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import java.util.List;

public class LDAPMembershipToUsernamePager extends LDAPSingleStringPager
{
    public static final Category log = Category.getInstance(LDAPMembershipToUsernamePager.class);

    public LDAPMembershipToUsernamePager(LdapContextFactory repository, LDAPPagerInfo info)
    {
        super(repository, info);
    }

    protected List preloadSearchResult(SearchResult result, List prefetched) throws EntityException
    {
        try
        {
            Attributes entityAttributes = result.getAttributes();
            String attributeToFind = returningAttributes[0];
            Attribute attr = entityAttributes.get(attributeToFind);

            String val;

            if (attr != null && attr.size() > 0)
            {
                if (attr.size() == 1)
                {
                    val = (String) attr.get();
                    prefetched.add(PagerUtils.extractSearchResultName(val));
                }
                else
                {
                    NamingEnumeration interiorList = attr.getAll();

                    while (interiorList.hasMoreElements())
                    {
                        val = (String) interiorList.nextElement();
                        String username = null;
                        try
                        {
                            username = PagerUtils.extractSearchResultName(val);
                        }
                        catch (Exception e) // try catch here so that we will continue to add usernames that _can_ be processed
                        {
                            log.error("Error extracting username from '" + val + "'", e);
                        }
                        prefetched.add(username);
                    }
                }
            }
        }
        catch (Throwable t)
        {
            log.error("Error converting search result: " + result + " into list of members as usernames.", t);
        }

        return prefetched;
    }
}
