package com.atlassian.user.impl.ldap.properties;

public class DefaultLdapConnectionProperties implements LdapConnectionProperties
{
    public static final int DEFAULT_LDAP_PORT = 389;
    public static final int DEFAULT_BATCH_SIZE = 1000;
    public static final String DEFAULT_AUTHENTICATION = "simple";

    private static final String LDAPS_PROTOCOL = "ldaps";
    private static final String LDAP_PROTOCOL = "ldap";

    private String securityPrincipal;
    private String securityCredential;
    private String host;
    private int port = DEFAULT_LDAP_PORT;
    private String jndiInitialContextFactoryIdentifier;
    private int searchBatchSize = DEFAULT_BATCH_SIZE;
    private String securityAuthentication = DEFAULT_AUTHENTICATION;
    private String securityProtocol;
    private boolean isPoolingOn = true;

    /**
     * Overrides host and port, if present.
     * @see #getProviderURL()
     */
    private String providerURL;

    public String getSecurityPrincipal()
    {
        return securityPrincipal;
    }

    public String getSecurityCredential()
    {
        return securityCredential;
    }

    /**
     * If the provider URL has been set explicitly by {@link #setProviderURL(String)} returns that value,
     * otherwise returns a concatenation of protocol, host and port in the form 'ldaps://localhost:389'.
     * 
     * @return the configured provider URL
     */
    public String getProviderURL()
    {
        if (providerURL != null)
            return providerURL;
        return getConnectionProtocol() + "://" + host + ":" + port;
    }

    private String getConnectionProtocol()
    {
        return isSslEnabled() ? LDAPS_PROTOCOL : LDAP_PROTOCOL;
    }

    private boolean isSslEnabled()
    {
        return securityProtocol != null && securityProtocol.toLowerCase().indexOf("ssl") != -1;
    }

    public String getJNDIInitialContextFactoryIdentifier()
    {
        return jndiInitialContextFactoryIdentifier;
    }

    public int getSearchBatchSize()
    {
        return searchBatchSize;
    }

    public String getSecurityAuthentication()
    {
        return securityAuthentication;
    }

    public String getSecurityProtocol()
    {
        return securityProtocol;
    }

    public boolean isPoolingOn()
    {
        return isPoolingOn;
    }

    public void setSecurityPrincipal(String securityPrincipal)
    {
        this.securityPrincipal = securityPrincipal;
    }

    public void setSecurityCredential(String securityCredential)
    {
        this.securityCredential = securityCredential;
    }

    public void setHost(String host)
    {
        this.host = host;
    }

    public void setPort(int port)
    {
        this.port = port;
    }

    public void setJndiInitialContextFactoryIdentifier(String jndiInitialContextFactoryIdentifier)
    {
        this.jndiInitialContextFactoryIdentifier = jndiInitialContextFactoryIdentifier;
    }

    public void setSearchBatchSize(int searchBatchSize)
    {
        this.searchBatchSize = searchBatchSize;
    }

    public void setSecurityAuthentication(String securityAuthentication)
    {
        this.securityAuthentication = securityAuthentication;
    }

    public void setSecurityProtocol(String securityProtocol)
    {
        this.securityProtocol = securityProtocol;
    }

    public void setPoolingOn(boolean poolingOn)
    {
        isPoolingOn = poolingOn;
    }

    public void setProviderURL(String providerURL)
    {
        this.providerURL = providerURL;
    }

    public String toString()
    {
        return "{ url: " + getProviderURL() + ", " +
            "authentication: '" + getSecurityAuthentication() + "', " +
            "protocol: '" + getSecurityProtocol() + "', " +
            "poolingOn: '" + isPoolingOn() + "' }";
    }
}
