package com.atlassian.user.impl.hibernate;

import com.atlassian.user.Caching;
import com.atlassian.user.ExternalEntity;
import com.atlassian.user.impl.cache.Cache;
import com.atlassian.user.impl.cache.CacheManager;

public class CachingExternalEntityDAO extends DefaultExternalEntityDAO implements Caching
{
    private CacheManager cacheManager;

    public void setCacheManager(CacheManager cacheManager)
    {
        this.cacheManager = cacheManager;
    }

    public ExternalEntity getExternalEntity(final String externalEntityName)
    {
        Cache nameCache = cacheManager.getCache(this.getClass().getName() + ".externalEntityName");
        Long id = (Long) nameCache.get(externalEntityName);
        if (id != null)
            return (ExternalEntity) getHibernateTemplate().get(DefaultHibernateExternalEntity.class, id);

        ExternalEntity externalEntity = super.getExternalEntity(externalEntityName);
        if (externalEntity != null)
            nameCache.put(externalEntityName, new Long(externalEntity.getId()));

        return externalEntity;
    }

    public void removeExternalEntity(final String externalEntityName)
    {
        Cache nameCache = cacheManager.getCache(this.getClass().getName() + ".externalEntityName");
        nameCache.remove(externalEntityName);
        super.removeExternalEntity(externalEntityName);
    }
}
