package com.atlassian.user.impl.ehcache.util;

import org.apache.log4j.Category;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;

import com.atlassian.user.EntityException;


public class DefaultCacheManager implements CacheManager
{
    private static final Category log = Category.getInstance(DefaultCacheManager.class);
    private net.sf.ehcache.CacheManager ehcacheManager;

    public DefaultCacheManager()
    {
        try
        {
            ehcacheManager = net.sf.ehcache.CacheManager.create();
        }
        catch (CacheException e)
        {
            log.error("Could not instantiate cacheManager: " + e.getMessage());
        }
    }

    public Cache getCache(String name) throws EntityException
    {
        if (!ehcacheManager.cacheExists(name))
        {
            try
            {
                log.warn("Cache named " + name + " was not in ehcache.xml. Using default settings.");
                ehcacheManager.addCache(name);
            }
            catch (CacheException e)
            {
                throw new EntityException(e);
            }
        }

        return ehcacheManager.getCache(name);
    }

    public void flushCaches()
    {
        for (int i = 0; i < ehcacheManager.getCacheNames().length; i++)
        {
            String cacheName = ehcacheManager.getCacheNames()[i];
            try
            {
                ehcacheManager.getCache(cacheName).removeAll();
            }
            catch (CacheException e)
            {
                log.error("Could not remove cache contents: " + e, e);
            }
        }
    }
}
