package com.atlassian.user.impl.as.security.password;

import com.atlassian.security.password.DefaultPasswordEncoder;
import com.atlassian.security.password.PasswordEncoder;
import com.atlassian.user.security.password.PasswordEncryptor;
import org.apache.log4j.Logger;

/**
 * Provides password encryption using atlassian-security's {@link PasswordEncoder}. This means salted password hashes.
 */
public class AtlassianSecurityPasswordEncryptor implements PasswordEncryptor
{
    @SuppressWarnings("UnusedDeclaration")
    private static final Logger log = Logger.getLogger(AtlassianSecurityPasswordEncryptor.class);

    private static final PasswordEncoder PASSWORD_ENCODER = DefaultPasswordEncoder.getDefaultInstance();

    @Override
    public String encrypt(String unencryptedPassword)
    {
        return PASSWORD_ENCODER.encodePassword(unencryptedPassword);
    }
}
