package com.atlassian.user.configuration;

import com.atlassian.user.GroupManager;
import com.atlassian.user.UserManager;
import com.atlassian.user.impl.delegation.DelegatingListGroupManager;
import com.atlassian.user.impl.delegation.DelegatingListUserManager;
import com.atlassian.user.impl.delegation.properties.DelegatingPropertySetFactory;
import com.atlassian.user.impl.delegation.search.query.DelegatingEntityQueryParser;
import com.atlassian.user.impl.delegation.security.authentication.DelegatingAuthenticator;
import com.atlassian.user.properties.PropertySetFactory;
import com.atlassian.user.repository.DefaultRepositoryIdentifier;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.query.EntityQueryParser;
import com.atlassian.user.security.authentication.Authenticator;

import java.util.*;

public class DefaultDelegationAccessor implements DelegationAccessor
{
    private Map repositoryAccessors = new HashMap();
    private List delegationOrder = new ArrayList();

    private DelegatingAuthenticator delegatingAuthenticator;
    private DelegatingListGroupManager delegatingGroupManager;
    private DelegatingPropertySetFactory delegatingPropertySetFactory;
    private DelegatingListUserManager delegatingUserManager;
    private DelegatingEntityQueryParser delegatingEntityQueryParser;

    private List authenticators = new ArrayList();
    private List userManagers = new ArrayList();
    private List groupManagers = new ArrayList();
    private List propertySetFactories = new ArrayList();
    private List entityQueryParsers = new ArrayList();

    public DefaultDelegationAccessor()
    {
    }

    public DefaultDelegationAccessor(List/*<RepositoryAccessor>*/ repositoryAccessors)
    {
        for (Iterator iterator = repositoryAccessors.iterator(); iterator.hasNext();)
        {
            RepositoryAccessor accessor = (RepositoryAccessor) iterator.next();
            addRepositoryAccessor(accessor);
        }
    }

    public RepositoryIdentifier getIdentifier()
    {
        return new DefaultRepositoryIdentifier("delegatingRepository", "Delegating Repository");
    }

    public UserManager getUserManager()
    {
        return delegatingUserManager;
    }

    public GroupManager getGroupManager()
    {
        return delegatingGroupManager;
    }

    public PropertySetFactory getPropertySetFactory()
    {
        return delegatingPropertySetFactory;
    }

    public Authenticator getAuthenticator()
    {
        return delegatingAuthenticator;
    }

    public EntityQueryParser getEntityQueryParser()
    {
        return delegatingEntityQueryParser;
    }

    public RepositoryAccessor getRepositoryAccessor(String key)
    {
        for (Iterator it = repositoryAccessors.keySet().iterator(); it.hasNext();)
        {
            RepositoryIdentifier identifier = (RepositoryIdentifier) it.next();
            if (identifier.getKey().equals(key))
                return (RepositoryAccessor) repositoryAccessors.get(identifier);
        }
        return null;
    }

    public List getRepositoryAccessors()
    {
        List result = new LinkedList();
        for (Iterator it = delegationOrder.iterator(); it.hasNext();)
        {
            RepositoryIdentifier identifier = (RepositoryIdentifier) it.next();
            result.add(repositoryAccessors.get(identifier));
        }
        return result;
    }

    public void addRepositoryAccessor(RepositoryAccessor accessor)
    {
        repositoryAccessors.put(accessor.getIdentifier(), accessor);
        delegationOrder.add(accessor.getIdentifier());

        if (accessor.getAuthenticator() != null) authenticators.add(accessor.getAuthenticator());
        if (accessor.getUserManager() != null) userManagers.add(accessor.getUserManager());
        if (accessor.getGroupManager() != null) groupManagers.add(accessor.getGroupManager());
        if (accessor.getPropertySetFactory() != null) propertySetFactories.add(accessor.getPropertySetFactory());
        if (accessor.getEntityQueryParser() != null) entityQueryParsers.add(accessor.getEntityQueryParser());

        delegatingUserManager = new DelegatingListUserManager(userManagers);
        delegatingAuthenticator = new DelegatingAuthenticator(delegatingUserManager, authenticators);
        delegatingPropertySetFactory = new DelegatingPropertySetFactory(propertySetFactories);
        delegatingGroupManager = new DelegatingListGroupManager(groupManagers);
        delegatingEntityQueryParser = new DelegatingEntityQueryParser(entityQueryParsers);
    }
}
