/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.search.page;

import com.atlassian.user.EntityException;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.PagerException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.log4j.Category;

public abstract class AbstractPrefetchingPager
implements Pager,
Iterator {
    public static final Category log = Category.getInstance((Class)AbstractPrefetchingPager.class);
    protected int idx = 0;
    private final int preloadLimit = 100;
    private final List prefetched = new ArrayList(100);
    protected int indexOfFirstItemInCurrentPage = 0;
    public boolean lastPage;

    public Iterator iterator() {
        return this;
    }

    public boolean isEmpty() {
        return !this.hasNext();
    }

    public List getCurrentPage() {
        return new ArrayList(this.prefetched);
    }

    public boolean hasNext() {
        int indexWithinPage = this.getIndexWithinPage();
        if (indexWithinPage == this.prefetched.size() && !this.lastPage) {
            this.preload();
            indexWithinPage = this.getIndexWithinPage();
        }
        return indexWithinPage < this.prefetched.size() || !this.lastPage;
    }

    protected abstract void preload();

    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected void preload(Iterator iterator) {
        this.prefetched.clear();
        int currentPos = 0;
        try {
            while (!this.lastPage && this.prefetched.size() < 100) {
                if (!iterator.hasNext()) {
                    this.lastPage = true;
                    break;
                }
                Object element = iterator.next();
                ArrayList entities = new ArrayList();
                this.fetch(element, entities);
                Iterator i = entities.iterator();
                while (i.hasNext() && this.prefetched.size() < 100) {
                    Object r = i.next();
                    if (currentPos >= this.idx) {
                        this.prefetched.add(r);
                    }
                    ++currentPos;
                }
            }
            if (this.prefetched.size() < 100) {
                this.lastPage = true;
            }
        }
        catch (Exception e) {
            log.error((Object)("At index [" + this.idx + "]: " + e.getMessage()), (Throwable)e);
            this.lastPage = true;
        }
    }

    protected abstract List fetch(Object var1, List var2) throws EntityException;

    public void nextPage() {
        this.idx += 100;
        this.preload();
    }

    public int getIndex() {
        return this.idx;
    }

    public void skipTo(int idx) throws PagerException {
        this.idx = idx;
        this.preload();
        if (this.prefetched == null || this.prefetched.size() == 0) {
            this.idx = -1;
        }
    }

    public boolean onLastPage() {
        return this.lastPage;
    }

    public int getIndexOfFirstItemInCurrentPage() {
        return this.indexOfFirstItemInCurrentPage;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        int indexWithinPage = this.getIndexWithinPage();
        Object nextObj = this.prefetched.get(indexWithinPage);
        ++this.idx;
        return nextObj;
    }

    protected int getIndexWithinPage() {
        return this.idx - this.indexOfFirstItemInCurrentPage;
    }
}

