/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.ldap;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.impl.ReadOnlyUserManager;
import com.atlassian.user.impl.ldap.DefaultLDAPUserFactory;
import com.atlassian.user.impl.ldap.LDAPValidator;
import com.atlassian.user.impl.ldap.properties.LdapSearchProperties;
import com.atlassian.user.impl.ldap.repository.LdapContextFactory;
import com.atlassian.user.impl.ldap.search.DefaultLDAPUserAdaptor;
import com.atlassian.user.impl.ldap.search.LDAPPagerInfo;
import com.atlassian.user.impl.ldap.search.LDAPUserAdaptor;
import com.atlassian.user.impl.ldap.search.LdapFilterFactory;
import com.atlassian.user.impl.ldap.search.page.LDAPEntityPager;
import com.atlassian.user.impl.ldap.search.page.LDAPSingleStringPager;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.page.Pager;
import com.atlassian.util.profiling.UtilTimerStack;
import net.sf.ldaptemplate.support.filter.EqualsFilter;
import net.sf.ldaptemplate.support.filter.Filter;
import org.apache.log4j.Logger;

public class LDAPUserManagerReadOnly
extends ReadOnlyUserManager {
    protected final Logger log = Logger.getLogger(this.getClass());
    private final RepositoryIdentifier repositoryIdentifier;
    private final LdapContextFactory repository;
    private final LdapSearchProperties searchProperties;
    private final LDAPUserAdaptor userAdaptor;

    public LDAPUserManagerReadOnly(RepositoryIdentifier repositoryIdentifier, LdapContextFactory repository, LdapSearchProperties searchProperties, LdapFilterFactory filterFactory) {
        this.repositoryIdentifier = repositoryIdentifier;
        this.repository = repository;
        this.searchProperties = searchProperties;
        this.userAdaptor = new DefaultLDAPUserAdaptor(repository, searchProperties, filterFactory);
    }

    public Pager getUsers() throws EntityException {
        this.profilePush(this.getClass().getName() + "_getUsers");
        LDAPPagerInfo info = this.userAdaptor.search(null);
        LDAPEntityPager pager = new LDAPEntityPager(this.repository, new DefaultLDAPUserFactory(this.searchProperties), info);
        this.profilePop(this.getClass().getName() + "_getUsers");
        return pager;
    }

    public Pager getUserNames() throws EntityException {
        LDAPPagerInfo info = this.userAdaptor.search(null, new String[]{this.searchProperties.getUsernameAttribute()});
        return new LDAPSingleStringPager(this.repository, info);
    }

    public User getUser(String username) throws EntityException {
        this.profilePush(this.getClass().getName() + "_getUser(" + username + ")");
        User user = null;
        try {
            LDAPPagerInfo info = this.userAdaptor.search((Filter)new EqualsFilter(this.searchProperties.getUsernameAttribute(), username));
            LDAPEntityPager pager = new LDAPEntityPager(this.repository, new DefaultLDAPUserFactory(this.searchProperties), info);
            if (pager.getCurrentPage().size() > 0) {
                user = (User)pager.getCurrentPage().get(0);
            }
        }
        catch (EntityException e) {
            this.log.error((Object)("Error retrieving user: '" + username + "' from LDAP."), (Throwable)e);
        }
        this.profilePop(this.getClass().getName() + "_getUser(" + username + ")");
        return user;
    }

    public RepositoryIdentifier getIdentifier() {
        return this.repositoryIdentifier;
    }

    public RepositoryIdentifier getRepository(Entity entity) throws EntityException {
        if (!LDAPValidator.validateLDAPEntity(entity)) {
            return null;
        }
        if (this.getUser(entity.getName()) == null) {
            return null;
        }
        return this.repositoryIdentifier;
    }

    private void profilePush(String key) {
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)key);
        }
    }

    private void profilePop(String key) {
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)key);
        }
    }
}

