/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.memory;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.impl.ReadOnlyUserManager;
import com.atlassian.user.impl.memory.provider.MemoryProvider;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.security.password.PasswordEncryptor;

public class MemoryUserManagerReadOnly
extends ReadOnlyUserManager
implements UserManager {
    private final RepositoryIdentifier repository;
    private final MemoryProvider provider;
    private final PasswordEncryptor encryptor;

    public MemoryUserManagerReadOnly(RepositoryIdentifier repository, MemoryProvider provider, PasswordEncryptor passwordEncryptor) {
        this.repository = repository;
        this.provider = provider;
        this.encryptor = passwordEncryptor;
    }

    public PasswordEncryptor getPasswordEncryptor(User user) throws EntityException {
        if (this.getUser(user.getName()) != null) {
            return this.encryptor;
        }
        return null;
    }

    public Pager getUsers() {
        return this.provider.getUsers();
    }

    public Pager getUserNames() throws EntityException {
        return this.provider.getUserNames();
    }

    public User getUser(String username) {
        return this.provider.getUser(username);
    }

    public RepositoryIdentifier getIdentifier() {
        return this.repository;
    }

    public RepositoryIdentifier getRepository(Entity entity) throws EntityException {
        if (this.getUser(entity.getName()) != null) {
            return this.repository;
        }
        return null;
    }
}

