/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.memory;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.impl.ReadOnlyGroupManager;
import com.atlassian.user.impl.memory.provider.MemoryProvider;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.page.Pager;

public class MemoryGroupManagerReadOnly
extends ReadOnlyGroupManager {
    private final RepositoryIdentifier repository;
    private final MemoryProvider provider;

    public MemoryGroupManagerReadOnly(RepositoryIdentifier config, MemoryProvider provider) {
        this.repository = config;
        this.provider = provider;
    }

    public Pager getGroups() {
        return this.provider.getGroups();
    }

    public boolean hasMembership(Group group, User user) {
        return this.provider.hasMembership(group, user);
    }

    public boolean supportsExternalMembership() throws EntityException {
        return false;
    }

    public Group getGroup(String groupName) {
        return this.provider.getGroup(groupName);
    }

    public Pager getGroups(User user) {
        return this.provider.getGroups(user);
    }

    public void setUserManager(UserManager userManager) {
    }

    public Pager getMemberNames(Group group) {
        return this.provider.getMemberNames(group);
    }

    public Pager getLocalMemberNames(Group group) throws EntityException {
        return this.provider.getLocalMemberNames(group);
    }

    public Pager getExternalMemberNames(Group group) throws EntityException {
        throw new UnsupportedOperationException("External membership is not supported");
    }

    public RepositoryIdentifier getIdentifier() {
        return this.repository;
    }

    public RepositoryIdentifier getRepository(Entity entity) throws EntityException {
        if (this.getGroup(entity.getName()) != null) {
            return this.repository;
        }
        return null;
    }
}

