/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.delegation.security.authentication;

import com.atlassian.user.EntityException;
import com.atlassian.user.UserManager;
import com.atlassian.user.impl.delegation.repository.DelegatingRepository;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.security.authentication.Authenticator;
import com.atlassian.util.profiling.UtilTimerStack;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class DelegatingAuthenticator
implements Authenticator {
    private static final Logger log = Logger.getLogger((Class)DelegatingAuthenticator.class);
    private final List authenticators;
    private final UserManager userManager;

    public DelegatingAuthenticator(UserManager userManager, List authenticators) {
        this.userManager = userManager;
        this.authenticators = authenticators;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticate(String username, String password) throws EntityException {
        boolean bl;
        List authenticators;
        block10: {
            if (UtilTimerStack.isActive()) {
                UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_authenticate(" + username + ")"));
            }
            RepositoryIdentifier repository = this.userManager.getRepository(this.userManager.getUser(username));
            authenticators = this.getAuthenticatorsForRepository(repository);
            if (!authenticators.isEmpty()) break block10;
            log.error((Object)("Failed to find authenticator for user " + username + " from repository " + repository));
            boolean bl2 = false;
            Object var9_7 = null;
            if (UtilTimerStack.isActive()) {
                UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_authenticate(" + username + ")"));
            }
            return bl2;
        }
        try {
            Iterator it = authenticators.iterator();
            while (it.hasNext()) {
                Authenticator authenticator = (Authenticator)it.next();
                if (!this.authenticate(authenticator, username, password)) break block11;
                bl = true;
                Object var9_8 = null;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (UtilTimerStack.isActive()) {
                UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_authenticate(" + username + ")"));
            }
            throw throwable;
        }
        {
            block11: {
                if (UtilTimerStack.isActive()) {
                    UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_authenticate(" + username + ")"));
                }
                return bl;
            }
            continue;
        }
        Object var9_9 = null;
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_authenticate(" + username + ")"));
        }
        return false;
    }

    private boolean authenticate(Authenticator authenticator, String username, String password) {
        try {
            return authenticator.authenticate(username, password);
        }
        catch (EntityException e) {
            log.error((Object)(authenticator.getRepository() + ": " + e.getMessage()));
            return false;
        }
    }

    private List getAuthenticatorsForRepository(RepositoryIdentifier repository) {
        LinkedList<Authenticator> result = new LinkedList<Authenticator>();
        Iterator it = this.authenticators.iterator();
        while (it.hasNext()) {
            Authenticator authenticator = (Authenticator)it.next();
            if (!authenticator.getRepository().equals(repository)) continue;
            result.add(authenticator);
        }
        return result;
    }

    public RepositoryIdentifier getRepository() {
        return new DelegatingRepository(this.authenticators);
    }

    public List getAuthenticators() {
        return this.authenticators;
    }
}

