/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.util;

import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.Filter;

public class LDAPUtils {
    private static final Logger log = Logger.getLogger(LDAPUtils.class);

    public static Filter makeAndFilter(Filter filter1, Filter filter2) {
        if (filter1 == null) {
            return filter2;
        }
        if (filter2 == null) {
            return filter1;
        }
        return new AndFilter().and(filter1).and(filter2);
    }

    public static boolean isValidFilter(String filter) {
        return StringUtils.isNotEmpty((String)filter) && filter.startsWith("(") && filter.endsWith(")") && filter.contains("=");
    }

    public static SearchControls createSearchControls(String[] attributesToReturn, boolean searchAllDepths, int timeLimitMillis) {
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(searchAllDepths ? 2 : 1);
        if (attributesToReturn != null) {
            ctls.setReturningAttributes(attributesToReturn);
        }
        ctls.setTimeLimit(timeLimitMillis);
        return ctls;
    }

    public static void closeQuietly(Context context) {
        try {
            if (context != null) {
                context.close();
            }
        }
        catch (NamingException e) {
            log.warn((Object)"Failed to close LDAP connection", (Throwable)e);
        }
    }

    public static void closeQuietly(NamingEnumeration<?> enumeration) {
        try {
            if (enumeration != null) {
                enumeration.close();
            }
        }
        catch (NamingException e) {
            log.warn((Object)"Failed to close enumeration", (Throwable)e);
        }
    }
}

